define([
    '../model/list',
    'Magento_Checkout/js/model/url-builder',
    'Magento_Checkout/js/model/quote',
    'Magento_Customer/js/model/customer',
    'mage/storage',
    'Magento_Checkout/js/model/error-processor',
    'Magento_Checkout/js/action/get-totals',
    'Magento_Checkout/js/model/full-screen-loader'
], function (list, urlBuilder, quote, customer, storage, errorProcessor, getTotals, fullScreenLoader) {
    'use strict';

    return function (messageContainer) {
        var serviceUrl,
            payload

        payload = {
            enabledOrderFees: list.getSelectedOrderFees().map(function(item) { return item }).join(",")
        };

        if (!customer.isLoggedIn()) {
            serviceUrl = urlBuilder.createUrl('/guest-carts/:cartId/set-fooman-orderfees', {
                cartId: quote.getQuoteId()
            });
        } else {
            serviceUrl = urlBuilder.createUrl('/carts/mine/set-fooman-orderfees', {});
        }

        fullScreenLoader.startLoader();

        return storage.post(
            serviceUrl, JSON.stringify(payload), true, 'application/json', {}
        ).done(
            function (response) {
                getTotals([], false);
            }
        ).fail(
            function (response) {
                errorProcessor.process(response, messageContainer);
            }
        ).always(
            function () {
                fullScreenLoader.stopLoader();
            }
        );
    };
});
