define([
    '../model/list',
    'Magento_Checkout/js/model/url-builder',
    'Magento_Checkout/js/model/quote',
    'Magento_Customer/js/model/customer',
    'mage/storage',
    'Magento_Checkout/js/model/error-processor',
], function (list, urlBuilder, quote, customer, storage, errorProcessor) {
    'use strict';

    return function (messageContainer) {
        var serviceUrl;

        if (!customer.isLoggedIn()) {
            serviceUrl = urlBuilder.createUrl('/guest-carts/:cartId/get-available-fooman-orderfees', {
                cartId: quote.getQuoteId()
            });
        } else {
            serviceUrl = urlBuilder.createUrl('/carts/mine/get-available-fooman-orderfees', {});
        }

        return storage.get(
            serviceUrl, false
        ).done(
            function (response) {
                list.getAvailableOrderFees().removeAll();
                list.getSelectedOrderFees().removeAll();
                if (response.length > 0) {
                    response.map(function(item) {
                        list.getAvailableOrderFees().push(item);
                        if (item.checked) {
                            list.getSelectedOrderFees().push(item.type_id);
                        }
                    });
                }
            }
        ).fail(
            function (response) {
                errorProcessor.process(response, messageContainer);
            }
        );
    };
});
