<?php
/**
 * @copyright Copyright (c) 2016 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Fooman\OrderFees\Plugin;

use Fooman\OrderFees\Model\EnabledOrderFees;
use Fooman\OrderFees\Model\EnabledOrderFeesFactory;
use Fooman\OrderFees\Model\OrderFeeType;
use Fooman\Totals\Api\Data\QuoteAddressTotalGroupInterface;
use Fooman\Totals\Plugin\LoadHandler as FoomanTotalsLoadHandler;
use Magento\Quote\Api\Data\CartExtensionInterfaceFactory;
use Magento\Quote\Api\Data\CartInterface;
use Magento\Quote\Model\Quote\Address;

class LoadHandler
{
    /**
     * @var EnabledOrderFeesFactory
     */
    private $enabledOrderFeesFactory;

    /**
     * @var OrderFeeType
     */
    private $orderFeeType;

    /**
     * @var CartExtensionInterfaceFactory
     */
    private $cartExtensionInterfaceFactory;

    public function __construct(
        EnabledOrderFeesFactory $enabledOrderFeesFactory,
        OrderFeeType $orderFeeType,
        CartExtensionInterfaceFactory $cartExtensionInterfaceFactory
    ) {
        $this->enabledOrderFeesFactory = $enabledOrderFeesFactory;
        $this->orderFeeType = $orderFeeType;
        $this->cartExtensionInterfaceFactory = $cartExtensionInterfaceFactory;
    }

    public function afterAfterLoad(
        FoomanTotalsLoadHandler $subject,
        CartInterface $quote
    ) {
        /** @var Address $address */
        if ($quote->getIsVirtual()) {
            $address = $quote->getBillingAddress();
        } else {
            $address = $quote->getShippingAddress();
        }

        $addrExtAttr = $address->getExtensionAttributes();
        if (!$addrExtAttr) {
            return $quote;
        }

        /** @var QuoteAddressTotalGroupInterface $foomanTotalGroup */
        $foomanTotalGroup = $addrExtAttr->getFoomanTotalGroup();
        if (!$foomanTotalGroup) {
            return $quote;
        }

        if (!$foomanTotalGroup->getItems()) {
            return $quote;
        }
        $cartExtension = $quote->getExtensionAttributes();
        if (null === $cartExtension) {
            $cartExtension = $this->cartExtensionInterfaceFactory->create();
        }
        /** @var EnabledOrderFees $enabledFees */
        $enabledFees = $this->enabledOrderFeesFactory->create();
        $enabledOrderFeeTypes = [];
        foreach ($foomanTotalGroup->getItems() as $foomanTotal) {
            if (strpos($foomanTotal->getTypeId(), $this->orderFeeType->getType()) === 0) {
                $enabledOrderFeeTypes[$foomanTotal->getTypeId()] = true;
            }
        }
        $enabledFees->setItems($enabledOrderFeeTypes);
        $cartExtension->setFoomanEnabledOrderFees($enabledFees);
        $quote->setExtensionAttributes($cartExtension);

        return $quote;
    }
}
