<?php

namespace Fooman\OrderFees\Model\System;

class DisplayArea implements \Magento\Framework\Data\OptionSourceInterface
{
    const BEFORE_PAYMENT_METHODS = 'beforePaymentMethods';
    const AFTER_PAYMENT_METHODS = 'afterPaymentMethods';
    const BEFORE_SHIPPING_METHODS = 'beforeShippingMethods';

    /**
     * @return array
     */
    public function toOptionArray()
    {
        return [
            ['value' => self::BEFORE_PAYMENT_METHODS, 'label' => __('Before Payment Methods')],
            ['value' => self::AFTER_PAYMENT_METHODS, 'label' => __('After Payment Methods')],
            ['value' => self::BEFORE_SHIPPING_METHODS, 'label' => __('Before Shipping Methods')]
        ];
    }
}
