<?php
/**
 * @copyright Copyright (c) 2016 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Fooman\OrderFees\Model;

use Fooman\Surcharge\Model\ResourceModel\Surcharge\CollectionFactory;
use Fooman\OrderFees\Model\OrderFeeType;
use Magento\Checkout\Model\ConfigProviderInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;

class SurchargeConfigProvider implements ConfigProviderInterface
{
    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;

    /**
     * @param ScopeConfigInterface  $scopeConfig
     */
    public function __construct(
        ScopeConfigInterface $scopeConfig
    ) {
        $this->scopeConfig = $scopeConfig;
    }

    /**
     * {@inheritdoc}
     */
    public function getConfig()
    {
        $result = [];
        $result['foomanOrderFeesConfig'] = [];
        $result['foomanOrderFeesConfig']['display_area'] = $this->scopeConfig
            ->getValue(
                'sales/fooman_order_fees/display_area',
                \Magento\Store\Model\ScopeInterface::SCOPE_STORE
            );

        $result['foomanOrderFeesConfig']['title'] = $this->scopeConfig
            ->getValue(
                'sales/fooman_order_fees/title',
                \Magento\Store\Model\ScopeInterface::SCOPE_STORE
            );

        return $result;
    }
}
