<?php

namespace Fooman\OrderFees\Model;

use Magento\Quote\Model\QuoteIdMaskFactory;
use Fooman\OrderFees\Api\GuestOrderFeesManagementInterface;
use Fooman\OrderFees\Api\OrderFeesManagementInterface;

/**
 * Guest order fees management object.
 */
class GuestOrderFeesManagement implements GuestOrderFeesManagementInterface
{
    /**
     * @var QuoteIdMaskFactory
     */
    private $quoteIdMaskFactory;

    /**
     * @var OrderFeesManagementInterface
     */
    private $orderFeesManagement;

    /**
     * @param OrderFeesManagementInterface $orderFeesManagement
     * @param QuoteIdMaskFactory $quoteIdMaskFactory
     */
    public function __construct(
        OrderFeesManagementInterface $orderFeesManagement,
        QuoteIdMaskFactory $quoteIdMaskFactory
    ) {
        $this->quoteIdMaskFactory = $quoteIdMaskFactory;
        $this->orderFeesManagement = $orderFeesManagement;
    }

    /**
     * {@inheritdoc}
     */
    public function get($cartId)
    {
        /** @var $quoteIdMask QuoteIdMask */
        $quoteIdMask = $this->quoteIdMaskFactory->create()->load($cartId, 'masked_id');
        return $this->orderFeesManagement->get($quoteIdMask->getQuoteId());
    }

    /**
     * {@inheritdoc}
     */
    public function getAvailable($cartId)
    {
        /** @var $quoteIdMask QuoteIdMask */
        $quoteIdMask = $this->quoteIdMaskFactory->create()->load($cartId, 'masked_id');
        return $this->orderFeesManagement->getAvailable($quoteIdMask->getQuoteId());
    }

    /**
     * {@inheritdoc}
     */
    public function set($cartId, $enabledOrderFees)
    {
        /** @var $quoteIdMask QuoteIdMask */
        $quoteIdMask = $this->quoteIdMaskFactory->create()->load($cartId, 'masked_id');
        return $this->orderFeesManagement->set($quoteIdMask->getQuoteId(), $enabledOrderFees);
    }

    /**
     * {@inheritdoc}
     */
    public function remove($cartId)
    {
        /** @var $quoteIdMask QuoteIdMask */
        $quoteIdMask = $this->quoteIdMaskFactory->create()->load($cartId, 'masked_id');
        return $this->orderFeesManagement->remove($quoteIdMask->getQuoteId());
    }
}