<?php

namespace Fooman\OrderFees\Model;

use Fooman\OrderFees\Api\Data\EnabledOrderFeesInterface;

class EnabledOrderFees implements EnabledOrderFeesInterface
{
    private $items = [];

    /**
     * {@inheritdoc}
     */
    public function getItems()
    {
        return $this->items;
    }

    /**
     * {@inheritdoc}
     */
    public function setItems($items)
    {
        $this->items = $items;
    }

    /**
     * {@inheritdoc}
     */
    public function enable($surcharge)
    {
        $this->items[$surcharge->getTypeId()] = true;
    }

    /**
     * {@inheritdoc}
     */
    public function disable($surcharge)
    {
        $this->items[$surcharge->getTypeId()] = false;
    }

    /**
     * {@inheritdoc}
     */
    public function isActive($surcharge)
    {
        if (isset($this->items[$surcharge->getTypeId()])) {
            return $this->items[$surcharge->getTypeId()] == true;
        }

        return false;
    }
}
