<?php

namespace Fooman\OrderFees\Model;

use Fooman\OrderFees\Api\Data\AvailableFeeInterface;

class AvailableFee implements AvailableFeeInterface
{

    private $typeId;
    private $checked;
    private $introText;
    private $label;

    public function __construct($typeId, $checked = false, $label ='', $introText = '')
    {
        $this->typeId = $typeId;
        $this->checked = $checked;
        $this->label = $label;
        $this->introText = $introText;
    }

    public function getTypeId()
    {
        return $this->typeId;
    }

    public function setTypeId($typeId)
    {
        $this->typeId = $typeId;
        return $this;
    }

    public function getLabel()
    {
        return $this->label;
    }

    public function setLabel($label)
    {
        $this->label = $label;
        return $this;
    }

    public function getChecked()
    {
        return $this->checked;
    }

    public function setChecked($status)
    {
        $this->checked = $status;
        return $this;
    }

    public function getIntroText()
    {
        return $this->introText;
    }

    public function setIntroText($text)
    {
        $this->introText = $text;
        return $this;
    }
}
