<?php
/**
 * @copyright Copyright (c) 2009 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Fooman\OrderFees\Block;

use Fooman\Surcharge\Model\SurchargeCalculation;
use Magento\Backend\Block\Template\Context;
use Magento\Backend\Block\Widget\Form\Generic;
use Magento\Framework\Data\FormFactory;
use Magento\Framework\Registry;
use Magento\Framework\Module\ModuleList;

class OrderFeeTab extends Generic
{

    /**
     * @var ModuleList
     */
    private $moduleList;

    public function __construct(
        Context     $context,
        Registry    $registry,
        FormFactory $formFactory,
        ModuleList  $moduleList,
        array       $data = []
    ) {
        $this->moduleList = $moduleList;
        parent::__construct($context, $registry, $formFactory, $data);
    }

    // phpcs:ignore PSR2.Methods.MethodDeclaration -- Magento 2 core use
    protected function _prepareForm()
    {
        $form = $this->_formFactory->create();
        $fieldset = $form->addFieldset('general', ['legend' => __('Order Fee Settings')]);

        $fieldset->addField(
            'is_optional',
            'select',
            [
                'label' => __('Optional Fee'),
                'title' => __('Optional Fee'),
                'name' => 'is_optional',
                'required' => true,
                'options' => [
                    1 => __('Yes'),
                    0 => __('No'),
                ],
                'note' => __('Optional Fees can be selected during checkout by the customer.')
            ]
        );

        $fieldset->addField('intro_text', 'textarea', [
            'label' => __('Checkout Description'),
            'title' => __('Checkout Description'),
            'name' => 'intro_text',
            'required' => false,
        ]);

        if ($this->moduleList->has('Fooman_ProductFees') ) {
            $fieldset->addField(
                'product_default_mode',
                'select',
                [
                    'label' => __('Products'),
                    'title' => __('Products'),
                    'name' => 'product_default_mode',
                    'required' => false,
                    'options' => $this->getModes()
                ]
            );
        }

        $fieldset->addField('min', 'text', [
            'label' => __('Order Minimum'),
            'title' => __('Order Minimum'),
            'name' => 'min',
            'required' => false,
        ]);

        $fieldset->addField('max', 'text', [
            'label' => __('Order Maximum'),
            'title' => __('Order Maximum'),
            'name' => 'max',
            'required' => false,
        ]);

        $fieldset->addField('calculation_mode', 'select', [
            'label' => __('Surcharge Calculation Mode'),
            'title' => __('Surcharge Calculation Mode'),
            'name' => 'calculation_mode',
            'required' => true,
            'options' => [
                '' => '',
                SurchargeCalculation::FIXED => __('Fixed'),
                SurchargeCalculation::PERCENT => __('Percent'),
                SurchargeCalculation::FIXED_PLUS_PERCENT => __('Fixed + Percent'),
                SurchargeCalculation::FIXED_MINIMUM => __('Maximum of Fixed or Percent'),
            ]
        ]);

        $fieldset->addField('rate', 'text', [
            'label' => __('Surcharge %'),
            'title' => __('Surcharge %'),
            'name' => 'rate',
            'required' => true,
        ]);

        $fieldset->addField('fixed', 'text', [
            'label' => __('Surcharge Fixed Cost'),
            'title' => __('Surcharge Fixed Cost'),
            'name' => 'fixed',
            'required' => true,
        ]);

        if ($this->_coreRegistry->registry('fooman_surcharge')) {
            $registry = $this->_coreRegistry->registry('fooman_surcharge');
            if ($registry->getDataRule()) {
                $formData = json_decode($registry->getDataRule(), true);
                $form->addValues($formData);
            }
        }

        $form->setFieldNameSuffix('orderfee');
        $this->setForm($form);
        return $this;
    }

    public function getModes()
    {
        return [
            'included' => __('are included by default'),
            'excluded' => __('are excluded by default'),
            'included_after_trigger' => __('are included once triggered')
        ];
    }
}
