<?php

namespace Fooman\OrderFees\Api;

/**
 * Order fees management interface for order carts.
 */
interface OrderFeesManagementInterface
{
    /**
     * Get all enabled order fees for a specified cart.
     *
     * @param string $cartId The cart ID.
     * @return \Fooman\OrderFees\Api\Data\FeeInterface[] The enabled order fees data.
     * @throws \Magento\Framework\Exception\NoSuchEntityException The specified cart does not exist.
     */
    public function get($cartId);

    /**
     * Get all available order fees for a specified cart.
     *
     * @param string $cartId The cart ID.
     * @return \Fooman\OrderFees\Api\Data\AvailableFeeInterface[] The available order fees data.
     * @throws \Magento\Framework\Exception\NoSuchEntityException The specified cart does not exist.
     */
    public function getAvailable($cartId);

    /**
     * Set enabled order fees for a specified cart.
     *
     * @param string $cartId The cart ID.
     * @param string $enabledOrderFees The enabled order fees data.
     * @return bool
     * @throws \Magento\Framework\Exception\NoSuchEntityException The specified cart does not exist.
     * @throws \Magento\Framework\Exception\CouldNotSaveException The specified order fee could not be added.
     */
    public function set($cartId, $enabledOrderFees);

    /**
     * Remove all order fees from a specified cart.
     *
     * @param string $cartId The cart ID.
     * @return bool
     * @throws \Magento\Framework\Exception\NoSuchEntityException The specified cart does not exist.
     * @throws \Magento\Framework\Exception\CouldNotDeleteException The specified order fee could not be deleted.
     */
    public function remove($cartId);
}
