<?php
/**
 * @copyright Copyright (c) 2016 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace Fooman\OrderFees\Api\Data;

interface EnabledOrderFeesInterface
{
    /**
     * Get items
     *
     * @return \Fooman\OrderFees\Api\Data\FeeInterface[]
     */
    public function getItems();

    /**
     * @param $items
     * @return void
     */
    public function setItems($items);

    /**
     * @param Fooman\Surcharge\Model\Surcharge $surcharge
     * @return void
     */
    public function enable($surcharge);

    /**
     * @param Fooman\Surcharge\Model\Surcharge $surcharge
     * @return void
     */
    public function disable($surcharge);

    /**
     * @param Fooman\Surcharge\Model\Surcharge $surcharge
     * @return bool
     */
    public function isActive($surcharge);
}
