<?php
/**
 * @copyright Copyright (c) 2016 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace Fooman\OrderFees\Api\Data;

interface AvailableFeeInterface
{
    /**
     * Return surcharge type_id
     *
     * @return string|null
     */
    public function getTypeId();

    /**
     * Set type_id
     *
     * @param string $typeId
     * @return $this
     */
    public function setTypeId($typeId);

    /**
     * Return Surcharge Description
     *
     * @return string|null
     */
    public function getLabel();

    /**
     * Set Surcharge Description
     *
     * @param string $label
     * @return $this
     */
    public function setLabel($label);

    /**
     * Return status if surcharge is active
     *
     * @return bool
     */
    public function getChecked();

    /**
     * Set active
     *
     * @param bool $status
     * @return $this
     */
    public function setChecked($status);

    /**
     * Return text describing surcharge in frontend
     *
     * @return string
     */
    public function getIntroText();

    /**
     * Set text describing surcharge in frontend
     *
     * @param string $text
     * @return $this
     */
    public function setIntroText($text);
}
