<?php
namespace Swissup\FieldManager\Model\Adminhtml\System\Config\Source;

/**
 * Factory class for @see \Swissup\FieldManager\Model\Adminhtml\System\Config\Source\Inputtype
 */
class InputtypeFactory
{
    /**
     * Object Manager instance
     *
     * @var \Magento\Framework\ObjectManagerInterface
     */
    protected $_objectManager = null;

    /**
     * Instance name to create
     *
     * @var string
     */
    protected $_instanceName = null;

    /**
     * Factory constructor
     *
     * @param \Magento\Framework\ObjectManagerInterface $objectManager
     * @param string $instanceName
     */
    public function __construct(\Magento\Framework\ObjectManagerInterface $objectManager, $instanceName = '\\Swissup\\FieldManager\\Model\\Adminhtml\\System\\Config\\Source\\Inputtype')
    {
        $this->_objectManager = $objectManager;
        $this->_instanceName = $instanceName;
    }

    /**
     * Create class instance with specified parameters
     *
     * @param array $data
     * @return \Swissup\FieldManager\Model\Adminhtml\System\Config\Source\Inputtype
     */
    public function create(array $data = [])
    {
        return $this->_objectManager->create($this->_instanceName, $data);
    }
}
