<?php
namespace Payone\Core\Model\Methods\Ratepay\Installment;

/**
 * Proxy class for @see \Payone\Core\Model\Methods\Ratepay\Installment
 */
class Proxy extends \Payone\Core\Model\Methods\Ratepay\Installment implements \Magento\Framework\ObjectManager\NoninterceptableInterface
{
    /**
     * Object Manager instance
     *
     * @var \Magento\Framework\ObjectManagerInterface
     */
    protected $_objectManager = null;

    /**
     * Proxied instance name
     *
     * @var string
     */
    protected $_instanceName = null;

    /**
     * Proxied instance
     *
     * @var \Payone\Core\Model\Methods\Ratepay\Installment
     */
    protected $_subject = null;

    /**
     * Instance shareability flag
     *
     * @var bool
     */
    protected $_isShared = null;

    /**
     * Proxy constructor
     *
     * @param \Magento\Framework\ObjectManagerInterface $objectManager
     * @param string $instanceName
     * @param bool $shared
     */
    public function __construct(\Magento\Framework\ObjectManagerInterface $objectManager, $instanceName = '\\Payone\\Core\\Model\\Methods\\Ratepay\\Installment', $shared = true)
    {
        $this->_objectManager = $objectManager;
        $this->_instanceName = $instanceName;
        $this->_isShared = $shared;
    }

    /**
     * @return array
     */
    public function __sleep()
    {
        return ['_subject', '_isShared', '_instanceName'];
    }

    /**
     * Retrieve ObjectManager from global scope
     */
    public function __wakeup()
    {
        $this->_objectManager = \Magento\Framework\App\ObjectManager::getInstance();
    }

    /**
     * Clone proxied instance
     */
    public function __clone()
    {
        $this->_subject = clone $this->_getSubject();
    }

    /**
     * Get proxied instance
     *
     * @return \Payone\Core\Model\Methods\Ratepay\Installment
     */
    protected function _getSubject()
    {
        if (!$this->_subject) {
            $this->_subject = true === $this->_isShared
                ? $this->_objectManager->get($this->_instanceName)
                : $this->_objectManager->create($this->_instanceName);
        }
        return $this->_subject;
    }

    /**
     * {@inheritdoc}
     */
    public function getSubTypeSpecificParameters(\Magento\Sales\Model\Order $oOrder)
    {
        return $this->_getSubject()->getSubTypeSpecificParameters($oOrder);
    }

    /**
     * {@inheritdoc}
     */
    public function getAllowedMonths(?\Magento\Quote\Api\Data\CartInterface $quote = null)
    {
        return $this->_getSubject()->getAllowedMonths($quote);
    }

    /**
     * {@inheritdoc}
     */
    public function assignData(\Magento\Framework\DataObject $data)
    {
        return $this->_getSubject()->assignData($data);
    }

    /**
     * {@inheritdoc}
     */
    public function getPaymentSpecificParameters(\Magento\Sales\Model\Order $oOrder)
    {
        return $this->_getSubject()->getPaymentSpecificParameters($oOrder);
    }

    /**
     * {@inheritdoc}
     */
    public function isAvailable(?\Magento\Quote\Api\Data\CartInterface $quote = null)
    {
        return $this->_getSubject()->isAvailable($quote);
    }

    /**
     * {@inheritdoc}
     */
    public function getPaymentSpecificCaptureParameters(\Magento\Sales\Model\Order $oOrder)
    {
        return $this->_getSubject()->getPaymentSpecificCaptureParameters($oOrder);
    }

    /**
     * {@inheritdoc}
     */
    public function getPaymentSpecificDebitParameters(\Magento\Sales\Model\Order $oOrder)
    {
        return $this->_getSubject()->getPaymentSpecificDebitParameters($oOrder);
    }

    /**
     * {@inheritdoc}
     */
    public function getClearingtype()
    {
        return $this->_getSubject()->getClearingtype();
    }

    /**
     * {@inheritdoc}
     */
    public function getAuthorizationMode()
    {
        return $this->_getSubject()->getAuthorizationMode();
    }

    /**
     * {@inheritdoc}
     */
    public function getOperationMode()
    {
        return $this->_getSubject()->getOperationMode();
    }

    /**
     * {@inheritdoc}
     */
    public function getSuccessUrl(?\Magento\Sales\Model\Order $oOrder = null)
    {
        return $this->_getSubject()->getSuccessUrl($oOrder);
    }

    /**
     * {@inheritdoc}
     */
    public function getCancelUrl()
    {
        return $this->_getSubject()->getCancelUrl();
    }

    /**
     * {@inheritdoc}
     */
    public function getErrorUrl()
    {
        return $this->_getSubject()->getErrorUrl();
    }

    /**
     * {@inheritdoc}
     */
    public function needsRedirectUrls()
    {
        return $this->_getSubject()->needsRedirectUrls();
    }

    /**
     * {@inheritdoc}
     */
    public function needsTransactionParam()
    {
        return $this->_getSubject()->needsTransactionParam();
    }

    /**
     * {@inheritdoc}
     */
    public function needsProductInfo()
    {
        return $this->_getSubject()->needsProductInfo();
    }

    /**
     * {@inheritdoc}
     */
    public function needsSepaDataOnDebit()
    {
        return $this->_getSubject()->needsSepaDataOnDebit();
    }

    /**
     * {@inheritdoc}
     */
    public function getCustomConfigParam($sParam, $sStoreCode = null)
    {
        return $this->_getSubject()->getCustomConfigParam($sParam, $sStoreCode);
    }

    /**
     * {@inheritdoc}
     */
    public function hasCustomConfig()
    {
        return $this->_getSubject()->hasCustomConfig();
    }

    /**
     * {@inheritdoc}
     */
    public function isGroupMethod()
    {
        return $this->_getSubject()->isGroupMethod();
    }

    /**
     * {@inheritdoc}
     */
    public function getGroupName()
    {
        return $this->_getSubject()->getGroupName();
    }

    /**
     * {@inheritdoc}
     */
    public function getSubType()
    {
        return $this->_getSubject()->getSubType();
    }

    /**
     * {@inheritdoc}
     */
    public function formatReferenceNumber($sRefNr)
    {
        return $this->_getSubject()->formatReferenceNumber($sRefNr);
    }

    /**
     * {@inheritdoc}
     */
    public function getNarrativeTextMaxLength()
    {
        return $this->_getSubject()->getNarrativeTextMaxLength();
    }

    /**
     * {@inheritdoc}
     */
    public function getInstructions()
    {
        return $this->_getSubject()->getInstructions();
    }

    /**
     * {@inheritdoc}
     */
    public function getConfigPaymentAction()
    {
        return $this->_getSubject()->getConfigPaymentAction();
    }

    /**
     * {@inheritdoc}
     */
    public function authorize(\Magento\Payment\Model\InfoInterface $payment, $amount)
    {
        return $this->_getSubject()->authorize($payment, $amount);
    }

    /**
     * {@inheritdoc}
     */
    public function refund(\Magento\Payment\Model\InfoInterface $payment, $amount)
    {
        return $this->_getSubject()->refund($payment, $amount);
    }

    /**
     * {@inheritdoc}
     */
    public function capture(\Magento\Payment\Model\InfoInterface $payment, $amount)
    {
        return $this->_getSubject()->capture($payment, $amount);
    }

    /**
     * {@inheritdoc}
     */
    public function canUseForCountry($country)
    {
        return $this->_getSubject()->canUseForCountry($country);
    }

    /**
     * {@inheritdoc}
     */
    public function setStore($storeId)
    {
        return $this->_getSubject()->setStore($storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function getStore()
    {
        return $this->_getSubject()->getStore();
    }

    /**
     * {@inheritdoc}
     */
    public function canOrder()
    {
        return $this->_getSubject()->canOrder();
    }

    /**
     * {@inheritdoc}
     */
    public function canAuthorize()
    {
        return $this->_getSubject()->canAuthorize();
    }

    /**
     * {@inheritdoc}
     */
    public function canCapture()
    {
        return $this->_getSubject()->canCapture();
    }

    /**
     * {@inheritdoc}
     */
    public function canCapturePartial()
    {
        return $this->_getSubject()->canCapturePartial();
    }

    /**
     * {@inheritdoc}
     */
    public function canCaptureOnce()
    {
        return $this->_getSubject()->canCaptureOnce();
    }

    /**
     * {@inheritdoc}
     */
    public function canRefund()
    {
        return $this->_getSubject()->canRefund();
    }

    /**
     * {@inheritdoc}
     */
    public function canRefundPartialPerInvoice()
    {
        return $this->_getSubject()->canRefundPartialPerInvoice();
    }

    /**
     * {@inheritdoc}
     */
    public function canVoid()
    {
        return $this->_getSubject()->canVoid();
    }

    /**
     * {@inheritdoc}
     */
    public function canUseInternal()
    {
        return $this->_getSubject()->canUseInternal();
    }

    /**
     * {@inheritdoc}
     */
    public function canUseCheckout()
    {
        return $this->_getSubject()->canUseCheckout();
    }

    /**
     * {@inheritdoc}
     */
    public function canEdit()
    {
        return $this->_getSubject()->canEdit();
    }

    /**
     * {@inheritdoc}
     */
    public function canFetchTransactionInfo()
    {
        return $this->_getSubject()->canFetchTransactionInfo();
    }

    /**
     * {@inheritdoc}
     */
    public function fetchTransactionInfo(\Magento\Payment\Model\InfoInterface $payment, $transactionId)
    {
        return $this->_getSubject()->fetchTransactionInfo($payment, $transactionId);
    }

    /**
     * {@inheritdoc}
     */
    public function isGateway()
    {
        return $this->_getSubject()->isGateway();
    }

    /**
     * {@inheritdoc}
     */
    public function isOffline()
    {
        return $this->_getSubject()->isOffline();
    }

    /**
     * {@inheritdoc}
     */
    public function isInitializeNeeded()
    {
        return $this->_getSubject()->isInitializeNeeded();
    }

    /**
     * {@inheritdoc}
     */
    public function canUseForCurrency($currencyCode)
    {
        return $this->_getSubject()->canUseForCurrency($currencyCode);
    }

    /**
     * {@inheritdoc}
     */
    public function getCode()
    {
        return $this->_getSubject()->getCode();
    }

    /**
     * {@inheritdoc}
     */
    public function getFormBlockType()
    {
        return $this->_getSubject()->getFormBlockType();
    }

    /**
     * {@inheritdoc}
     */
    public function getInfoBlockType()
    {
        return $this->_getSubject()->getInfoBlockType();
    }

    /**
     * {@inheritdoc}
     */
    public function getInfoInstance()
    {
        return $this->_getSubject()->getInfoInstance();
    }

    /**
     * {@inheritdoc}
     */
    public function setInfoInstance(\Magento\Payment\Model\InfoInterface $info)
    {
        return $this->_getSubject()->setInfoInstance($info);
    }

    /**
     * {@inheritdoc}
     */
    public function validate()
    {
        return $this->_getSubject()->validate();
    }

    /**
     * {@inheritdoc}
     */
    public function order(\Magento\Payment\Model\InfoInterface $payment, $amount)
    {
        return $this->_getSubject()->order($payment, $amount);
    }

    /**
     * {@inheritdoc}
     */
    public function cancel(\Magento\Payment\Model\InfoInterface $payment)
    {
        return $this->_getSubject()->cancel($payment);
    }

    /**
     * {@inheritdoc}
     */
    public function void(\Magento\Payment\Model\InfoInterface $payment)
    {
        return $this->_getSubject()->void($payment);
    }

    /**
     * {@inheritdoc}
     */
    public function canReviewPayment()
    {
        return $this->_getSubject()->canReviewPayment();
    }

    /**
     * {@inheritdoc}
     */
    public function acceptPayment(\Magento\Payment\Model\InfoInterface $payment)
    {
        return $this->_getSubject()->acceptPayment($payment);
    }

    /**
     * {@inheritdoc}
     */
    public function denyPayment(\Magento\Payment\Model\InfoInterface $payment)
    {
        return $this->_getSubject()->denyPayment($payment);
    }

    /**
     * {@inheritdoc}
     */
    public function getTitle()
    {
        return $this->_getSubject()->getTitle();
    }

    /**
     * {@inheritdoc}
     */
    public function getConfigData($field, $storeId = null)
    {
        return $this->_getSubject()->getConfigData($field, $storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function isActive($storeId = null)
    {
        return $this->_getSubject()->isActive($storeId);
    }

    /**
     * {@inheritdoc}
     */
    public function initialize($paymentAction, $stateObject)
    {
        return $this->_getSubject()->initialize($paymentAction, $stateObject);
    }

    /**
     * {@inheritdoc}
     */
    public function getDebugFlag()
    {
        return $this->_getSubject()->getDebugFlag();
    }

    /**
     * {@inheritdoc}
     */
    public function debugData($debugData)
    {
        return $this->_getSubject()->debugData($debugData);
    }

    /**
     * {@inheritdoc}
     */
    public function getDebugReplacePrivateDataKeys()
    {
        return $this->_getSubject()->getDebugReplacePrivateDataKeys();
    }

    /**
     * {@inheritdoc}
     */
    public function getCustomAttributes()
    {
        return $this->_getSubject()->getCustomAttributes();
    }

    /**
     * {@inheritdoc}
     */
    public function getCustomAttribute($attributeCode)
    {
        return $this->_getSubject()->getCustomAttribute($attributeCode);
    }

    /**
     * {@inheritdoc}
     */
    public function setCustomAttributes(array $attributes)
    {
        return $this->_getSubject()->setCustomAttributes($attributes);
    }

    /**
     * {@inheritdoc}
     */
    public function setCustomAttribute($attributeCode, $attributeValue)
    {
        return $this->_getSubject()->setCustomAttribute($attributeCode, $attributeValue);
    }

    /**
     * {@inheritdoc}
     */
    public function setData($key, $value = null)
    {
        return $this->_getSubject()->setData($key, $value);
    }

    /**
     * {@inheritdoc}
     */
    public function unsetData($key = null)
    {
        return $this->_getSubject()->unsetData($key);
    }

    /**
     * {@inheritdoc}
     */
    public function getData($key = '', $index = null)
    {
        return $this->_getSubject()->getData($key, $index);
    }

    /**
     * {@inheritdoc}
     */
    public function setId($value)
    {
        return $this->_getSubject()->setId($value);
    }

    /**
     * {@inheritdoc}
     */
    public function setIdFieldName($name)
    {
        return $this->_getSubject()->setIdFieldName($name);
    }

    /**
     * {@inheritdoc}
     */
    public function getIdFieldName()
    {
        return $this->_getSubject()->getIdFieldName();
    }

    /**
     * {@inheritdoc}
     */
    public function getId()
    {
        return $this->_getSubject()->getId();
    }

    /**
     * {@inheritdoc}
     */
    public function isDeleted($isDeleted = null)
    {
        return $this->_getSubject()->isDeleted($isDeleted);
    }

    /**
     * {@inheritdoc}
     */
    public function hasDataChanges()
    {
        return $this->_getSubject()->hasDataChanges();
    }

    /**
     * {@inheritdoc}
     */
    public function setDataChanges($value)
    {
        return $this->_getSubject()->setDataChanges($value);
    }

    /**
     * {@inheritdoc}
     */
    public function getOrigData($key = null)
    {
        return $this->_getSubject()->getOrigData($key);
    }

    /**
     * {@inheritdoc}
     */
    public function setOrigData($key = null, $data = null)
    {
        return $this->_getSubject()->setOrigData($key, $data);
    }

    /**
     * {@inheritdoc}
     */
    public function dataHasChangedFor($field)
    {
        return $this->_getSubject()->dataHasChangedFor($field);
    }

    /**
     * {@inheritdoc}
     */
    public function getResourceName()
    {
        return $this->_getSubject()->getResourceName();
    }

    /**
     * {@inheritdoc}
     */
    public function getResourceCollection()
    {
        return $this->_getSubject()->getResourceCollection();
    }

    /**
     * {@inheritdoc}
     */
    public function getCollection()
    {
        return $this->_getSubject()->getCollection();
    }

    /**
     * {@inheritdoc}
     */
    public function load($modelId, $field = null)
    {
        return $this->_getSubject()->load($modelId, $field);
    }

    /**
     * {@inheritdoc}
     */
    public function beforeLoad($identifier, $field = null)
    {
        return $this->_getSubject()->beforeLoad($identifier, $field);
    }

    /**
     * {@inheritdoc}
     */
    public function afterLoad()
    {
        return $this->_getSubject()->afterLoad();
    }

    /**
     * {@inheritdoc}
     */
    public function isSaveAllowed()
    {
        return $this->_getSubject()->isSaveAllowed();
    }

    /**
     * {@inheritdoc}
     */
    public function setHasDataChanges($flag)
    {
        return $this->_getSubject()->setHasDataChanges($flag);
    }

    /**
     * {@inheritdoc}
     */
    public function save()
    {
        return $this->_getSubject()->save();
    }

    /**
     * {@inheritdoc}
     */
    public function afterCommitCallback()
    {
        return $this->_getSubject()->afterCommitCallback();
    }

    /**
     * {@inheritdoc}
     */
    public function isObjectNew($flag = null)
    {
        return $this->_getSubject()->isObjectNew($flag);
    }

    /**
     * {@inheritdoc}
     */
    public function beforeSave()
    {
        return $this->_getSubject()->beforeSave();
    }

    /**
     * {@inheritdoc}
     */
    public function validateBeforeSave()
    {
        return $this->_getSubject()->validateBeforeSave();
    }

    /**
     * {@inheritdoc}
     */
    public function getCacheTags()
    {
        return $this->_getSubject()->getCacheTags();
    }

    /**
     * {@inheritdoc}
     */
    public function cleanModelCache()
    {
        return $this->_getSubject()->cleanModelCache();
    }

    /**
     * {@inheritdoc}
     */
    public function afterSave()
    {
        return $this->_getSubject()->afterSave();
    }

    /**
     * {@inheritdoc}
     */
    public function delete()
    {
        return $this->_getSubject()->delete();
    }

    /**
     * {@inheritdoc}
     */
    public function beforeDelete()
    {
        return $this->_getSubject()->beforeDelete();
    }

    /**
     * {@inheritdoc}
     */
    public function afterDelete()
    {
        return $this->_getSubject()->afterDelete();
    }

    /**
     * {@inheritdoc}
     */
    public function afterDeleteCommit()
    {
        return $this->_getSubject()->afterDeleteCommit();
    }

    /**
     * {@inheritdoc}
     */
    public function getResource()
    {
        return $this->_getSubject()->getResource();
    }

    /**
     * {@inheritdoc}
     */
    public function getEntityId()
    {
        return $this->_getSubject()->getEntityId();
    }

    /**
     * {@inheritdoc}
     */
    public function setEntityId($entityId)
    {
        return $this->_getSubject()->setEntityId($entityId);
    }

    /**
     * {@inheritdoc}
     */
    public function clearInstance()
    {
        return $this->_getSubject()->clearInstance();
    }

    /**
     * {@inheritdoc}
     */
    public function getStoredData()
    {
        return $this->_getSubject()->getStoredData();
    }

    /**
     * {@inheritdoc}
     */
    public function getEventPrefix()
    {
        return $this->_getSubject()->getEventPrefix();
    }

    /**
     * {@inheritdoc}
     */
    public function addData(array $arr)
    {
        return $this->_getSubject()->addData($arr);
    }

    /**
     * {@inheritdoc}
     */
    public function getDataByPath($path)
    {
        return $this->_getSubject()->getDataByPath($path);
    }

    /**
     * {@inheritdoc}
     */
    public function getDataByKey($key)
    {
        return $this->_getSubject()->getDataByKey($key);
    }

    /**
     * {@inheritdoc}
     */
    public function setDataUsingMethod($key, $args = [])
    {
        return $this->_getSubject()->setDataUsingMethod($key, $args);
    }

    /**
     * {@inheritdoc}
     */
    public function getDataUsingMethod($key, $args = null)
    {
        return $this->_getSubject()->getDataUsingMethod($key, $args);
    }

    /**
     * {@inheritdoc}
     */
    public function hasData($key = '')
    {
        return $this->_getSubject()->hasData($key);
    }

    /**
     * {@inheritdoc}
     */
    public function toArray(array $keys = [])
    {
        return $this->_getSubject()->toArray($keys);
    }

    /**
     * {@inheritdoc}
     */
    public function convertToArray(array $keys = [])
    {
        return $this->_getSubject()->convertToArray($keys);
    }

    /**
     * {@inheritdoc}
     */
    public function toXml(array $keys = [], $rootName = 'item', $addOpenTag = false, $addCdata = true)
    {
        return $this->_getSubject()->toXml($keys, $rootName, $addOpenTag, $addCdata);
    }

    /**
     * {@inheritdoc}
     */
    public function convertToXml(array $arrAttributes = [], $rootName = 'item', $addOpenTag = false, $addCdata = true)
    {
        return $this->_getSubject()->convertToXml($arrAttributes, $rootName, $addOpenTag, $addCdata);
    }

    /**
     * {@inheritdoc}
     */
    public function toJson(array $keys = [])
    {
        return $this->_getSubject()->toJson($keys);
    }

    /**
     * {@inheritdoc}
     */
    public function convertToJson(array $keys = [])
    {
        return $this->_getSubject()->convertToJson($keys);
    }

    /**
     * {@inheritdoc}
     */
    public function toString($format = '')
    {
        return $this->_getSubject()->toString($format);
    }

    /**
     * {@inheritdoc}
     */
    public function __call($method, $args)
    {
        return $this->_getSubject()->__call($method, $args);
    }

    /**
     * {@inheritdoc}
     */
    public function isEmpty()
    {
        return $this->_getSubject()->isEmpty();
    }

    /**
     * {@inheritdoc}
     */
    public function serialize($keys = [], $valueSeparator = '=', $fieldSeparator = ' ', $quote = '"')
    {
        return $this->_getSubject()->serialize($keys, $valueSeparator, $fieldSeparator, $quote);
    }

    /**
     * {@inheritdoc}
     */
    public function debug($data = null, &$objects = [])
    {
        return $this->_getSubject()->debug($data, $objects);
    }

    /**
     * {@inheritdoc}
     */
    public function offsetSet($offset, $value)
    {
        return $this->_getSubject()->offsetSet($offset, $value);
    }

    /**
     * {@inheritdoc}
     */
    public function offsetExists($offset)
    {
        return $this->_getSubject()->offsetExists($offset);
    }

    /**
     * {@inheritdoc}
     */
    public function offsetUnset($offset)
    {
        return $this->_getSubject()->offsetUnset($offset);
    }

    /**
     * {@inheritdoc}
     */
    public function offsetGet($offset)
    {
        return $this->_getSubject()->offsetGet($offset);
    }
}
