<?php
namespace Magento\Sales\Api\Data;

/**
 * ExtensionInterface class for @see \Magento\Sales\Api\Data\OrderInterface
 */
interface OrderExtensionInterface extends \Magento\Framework\Api\ExtensionAttributesInterface
{
    /**
     * @return \Magento\Sales\Api\Data\ShippingAssignmentInterface[]|null
     */
    public function getShippingAssignments();

    /**
     * @param \Magento\Sales\Api\Data\ShippingAssignmentInterface[] $shippingAssignments
     * @return $this
     */
    public function setShippingAssignments($shippingAssignments);

    /**
     * @return \Magento\Payment\Api\Data\PaymentAdditionalInfoInterface[]|null
     */
    public function getPaymentAdditionalInfo();

    /**
     * @param \Magento\Payment\Api\Data\PaymentAdditionalInfoInterface[] $paymentAdditionalInfo
     * @return $this
     */
    public function setPaymentAdditionalInfo($paymentAdditionalInfo);

    /**
     * @return \Magento\GiftMessage\Api\Data\MessageInterface|null
     */
    public function getGiftMessage();

    /**
     * @param \Magento\GiftMessage\Api\Data\MessageInterface $giftMessage
     * @return $this
     */
    public function setGiftMessage(\Magento\GiftMessage\Api\Data\MessageInterface $giftMessage);

    /**
     * @return string|null
     */
    public function getPickupLocationCode();

    /**
     * @param string $pickupLocationCode
     * @return $this
     */
    public function setPickupLocationCode($pickupLocationCode);

    /**
     * @return int|null
     */
    public function getNotificationSent();

    /**
     * @param int $notificationSent
     * @return $this
     */
    public function setNotificationSent($notificationSent);

    /**
     * @return int|null
     */
    public function getSendNotification();

    /**
     * @param int $sendNotification
     * @return $this
     */
    public function setSendNotification($sendNotification);

    /**
     * @return \Magento\Tax\Api\Data\OrderTaxDetailsAppliedTaxInterface[]|null
     */
    public function getAppliedTaxes();

    /**
     * @param \Magento\Tax\Api\Data\OrderTaxDetailsAppliedTaxInterface[] $appliedTaxes
     * @return $this
     */
    public function setAppliedTaxes($appliedTaxes);

    /**
     * @return \Magento\Tax\Api\Data\OrderTaxDetailsItemInterface[]|null
     */
    public function getItemAppliedTaxes();

    /**
     * @param \Magento\Tax\Api\Data\OrderTaxDetailsItemInterface[] $itemAppliedTaxes
     * @return $this
     */
    public function setItemAppliedTaxes($itemAppliedTaxes);

    /**
     * @return boolean|null
     */
    public function getConvertingFromQuote();

    /**
     * @param boolean $convertingFromQuote
     * @return $this
     */
    public function setConvertingFromQuote($convertingFromQuote);

    /**
     * @return \Fooman\Totals\Api\Data\TotalGroupInterface|null
     */
    public function getFoomanTotalGroup();

    /**
     * @param \Fooman\Totals\Api\Data\TotalGroupInterface $foomanTotalGroup
     * @return $this
     */
    public function setFoomanTotalGroup(\Fooman\Totals\Api\Data\TotalGroupInterface $foomanTotalGroup);

    /**
     * @return \Swissup\AddressFieldManager\Api\Data\FieldDataInterface[]|null
     */
    public function getSwissupAddressFields();

    /**
     * @param \Swissup\AddressFieldManager\Api\Data\FieldDataInterface[] $swissupAddressFields
     * @return $this
     */
    public function setSwissupAddressFields($swissupAddressFields);

    /**
     * @return \Swissup\CheckoutFields\Api\Data\FieldDataInterface[]|null
     */
    public function getSwissupCheckoutFields();

    /**
     * @param \Swissup\CheckoutFields\Api\Data\FieldDataInterface[] $swissupCheckoutFields
     * @return $this
     */
    public function setSwissupCheckoutFields($swissupCheckoutFields);

    /**
     * @return \Swissup\DeliveryDate\Api\Data\DeliverydateInterface|null
     */
    public function getSwissupDeliveryDate();

    /**
     * @param \Swissup\DeliveryDate\Api\Data\DeliverydateInterface $swissupDeliveryDate
     * @return $this
     */
    public function setSwissupDeliveryDate(\Swissup\DeliveryDate\Api\Data\DeliverydateInterface $swissupDeliveryDate);
}
