<?php
namespace Magento\Quote\Api\Data;

/**
 * Extension class for @see \Magento\Quote\Api\Data\TotalSegmentInterface
 */
class TotalSegmentExtension extends \Magento\Framework\Api\AbstractSimpleObject implements TotalSegmentExtensionInterface
{
    /**
     * @return \Magento\Tax\Api\Data\GrandTotalDetailsInterface[]|null
     */
    public function getTaxGrandtotalDetails()
    {
        return $this->_get('tax_grandtotal_details');
    }

    /**
     * @param \Magento\Tax\Api\Data\GrandTotalDetailsInterface[] $taxGrandtotalDetails
     * @return $this
     */
    public function setTaxGrandtotalDetails($taxGrandtotalDetails)
    {
        $this->setData('tax_grandtotal_details', $taxGrandtotalDetails);
        return $this;
    }

    /**
     * @return \Fooman\Totals\Api\Data\QuoteAddressTotalGroupInterface|null
     */
    public function getFoomanSurchargeDetails()
    {
        return $this->_get('fooman_surcharge_details');
    }

    /**
     * @param \Fooman\Totals\Api\Data\QuoteAddressTotalGroupInterface $foomanSurchargeDetails
     * @return $this
     */
    public function setFoomanSurchargeDetails(\Fooman\Totals\Api\Data\QuoteAddressTotalGroupInterface $foomanSurchargeDetails)
    {
        $this->setData('fooman_surcharge_details', $foomanSurchargeDetails);
        return $this;
    }
}
