<?php
namespace Magento\Quote\Api\Data;

/**
 * Extension class for @see \Magento\Quote\Api\Data\CartInterface
 */
class CartExtension extends \Magento\Framework\Api\AbstractSimpleObject implements CartExtensionInterface
{
    /**
     * @return \Magento\Quote\Api\Data\ShippingAssignmentInterface[]|null
     */
    public function getShippingAssignments()
    {
        return $this->_get('shipping_assignments');
    }

    /**
     * @param \Magento\Quote\Api\Data\ShippingAssignmentInterface[] $shippingAssignments
     * @return $this
     */
    public function setShippingAssignments($shippingAssignments)
    {
        $this->setData('shipping_assignments', $shippingAssignments);
        return $this;
    }

    /**
     * @return \Fooman\OrderFees\Api\Data\EnabledOrderFeesInterface|null
     */
    public function getFoomanEnabledOrderFees()
    {
        return $this->_get('fooman_enabled_order_fees');
    }

    /**
     * @param \Fooman\OrderFees\Api\Data\EnabledOrderFeesInterface $foomanEnabledOrderFees
     * @return $this
     */
    public function setFoomanEnabledOrderFees(\Fooman\OrderFees\Api\Data\EnabledOrderFeesInterface $foomanEnabledOrderFees)
    {
        $this->setData('fooman_enabled_order_fees', $foomanEnabledOrderFees);
        return $this;
    }
}
