<?php
namespace Magento\Quote\Api\Data;

/**
 * ExtensionInterface class for @see \Magento\Quote\Api\Data\AddressInterface
 */
interface AddressExtensionInterface extends \Magento\Framework\Api\ExtensionAttributesInterface
{
    /**
     * @return string|null
     */
    public function getPickupLocationCode();

    /**
     * @param string $pickupLocationCode
     * @return $this
     */
    public function setPickupLocationCode($pickupLocationCode);

    /**
     * @return \Magento\SalesRule\Api\Data\RuleDiscountInterface[]|null
     */
    public function getDiscounts();

    /**
     * @param \Magento\SalesRule\Api\Data\RuleDiscountInterface[] $discounts
     * @return $this
     */
    public function setDiscounts($discounts);

    /**
     * @return \Fooman\Totals\Api\Data\QuoteAddressTotalGroupInterface|null
     */
    public function getFoomanTotalGroup();

    /**
     * @param \Fooman\Totals\Api\Data\QuoteAddressTotalGroupInterface $foomanTotalGroup
     * @return $this
     */
    public function setFoomanTotalGroup(\Fooman\Totals\Api\Data\QuoteAddressTotalGroupInterface $foomanTotalGroup);

    /**
     * @return string|null
     */
    public function getGender();

    /**
     * @param string $gender
     * @return $this
     */
    public function setGender($gender);

    /**
     * @return string|null
     */
    public function getDateofbirth();

    /**
     * @param string $dateofbirth
     * @return $this
     */
    public function setDateofbirth($dateofbirth);

    /**
     * @return string|null
     */
    public function getSwissupValidation();

    /**
     * @param string $swissupValidation
     * @return $this
     */
    public function setSwissupValidation($swissupValidation);
}
