<?php
namespace Magento\Quote\Api\Data;

/**
 * Extension class for @see \Magento\Quote\Api\Data\AddressInterface
 */
class AddressExtension extends \Magento\Framework\Api\AbstractSimpleObject implements AddressExtensionInterface
{
    /**
     * @return string|null
     */
    public function getPickupLocationCode()
    {
        return $this->_get('pickup_location_code');
    }

    /**
     * @param string $pickupLocationCode
     * @return $this
     */
    public function setPickupLocationCode($pickupLocationCode)
    {
        $this->setData('pickup_location_code', $pickupLocationCode);
        return $this;
    }

    /**
     * @return \Magento\SalesRule\Api\Data\RuleDiscountInterface[]|null
     */
    public function getDiscounts()
    {
        return $this->_get('discounts');
    }

    /**
     * @param \Magento\SalesRule\Api\Data\RuleDiscountInterface[] $discounts
     * @return $this
     */
    public function setDiscounts($discounts)
    {
        $this->setData('discounts', $discounts);
        return $this;
    }

    /**
     * @return \Fooman\Totals\Api\Data\QuoteAddressTotalGroupInterface|null
     */
    public function getFoomanTotalGroup()
    {
        return $this->_get('fooman_total_group');
    }

    /**
     * @param \Fooman\Totals\Api\Data\QuoteAddressTotalGroupInterface $foomanTotalGroup
     * @return $this
     */
    public function setFoomanTotalGroup(\Fooman\Totals\Api\Data\QuoteAddressTotalGroupInterface $foomanTotalGroup)
    {
        $this->setData('fooman_total_group', $foomanTotalGroup);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getGender()
    {
        return $this->_get('gender');
    }

    /**
     * @param string $gender
     * @return $this
     */
    public function setGender($gender)
    {
        $this->setData('gender', $gender);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDateofbirth()
    {
        return $this->_get('dateofbirth');
    }

    /**
     * @param string $dateofbirth
     * @return $this
     */
    public function setDateofbirth($dateofbirth)
    {
        $this->setData('dateofbirth', $dateofbirth);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSwissupValidation()
    {
        return $this->_get('swissup_validation');
    }

    /**
     * @param string $swissupValidation
     * @return $this
     */
    public function setSwissupValidation($swissupValidation)
    {
        $this->setData('swissup_validation', $swissupValidation);
        return $this;
    }
}
