<?php
namespace Amasty\Pgrid\Model\Indexer\QtySold;

/**
 * Proxy class for @see \Amasty\Pgrid\Model\Indexer\QtySold
 */
class Proxy extends \Amasty\Pgrid\Model\Indexer\QtySold implements \Magento\Framework\ObjectManager\NoninterceptableInterface
{
    /**
     * Object Manager instance
     *
     * @var \Magento\Framework\ObjectManagerInterface
     */
    protected $_objectManager = null;

    /**
     * Proxied instance name
     *
     * @var string
     */
    protected $_instanceName = null;

    /**
     * Proxied instance
     *
     * @var \Amasty\Pgrid\Model\Indexer\QtySold
     */
    protected $_subject = null;

    /**
     * Instance shareability flag
     *
     * @var bool
     */
    protected $_isShared = null;

    /**
     * Proxy constructor
     *
     * @param \Magento\Framework\ObjectManagerInterface $objectManager
     * @param string $instanceName
     * @param bool $shared
     */
    public function __construct(\Magento\Framework\ObjectManagerInterface $objectManager, $instanceName = '\\Amasty\\Pgrid\\Model\\Indexer\\QtySold', $shared = true)
    {
        $this->_objectManager = $objectManager;
        $this->_instanceName = $instanceName;
        $this->_isShared = $shared;
    }

    /**
     * @return array
     */
    public function __sleep()
    {
        return ['_subject', '_isShared', '_instanceName'];
    }

    /**
     * Retrieve ObjectManager from global scope
     */
    public function __wakeup()
    {
        $this->_objectManager = \Magento\Framework\App\ObjectManager::getInstance();
    }

    /**
     * Clone proxied instance
     */
    public function __clone()
    {
        $this->_subject = clone $this->_getSubject();
    }

    /**
     * Get proxied instance
     *
     * @return \Amasty\Pgrid\Model\Indexer\QtySold
     */
    protected function _getSubject()
    {
        if (!$this->_subject) {
            $this->_subject = true === $this->_isShared
                ? $this->_objectManager->get($this->_instanceName)
                : $this->_objectManager->create($this->_instanceName);
        }
        return $this->_subject;
    }

    /**
     * {@inheritdoc}
     */
    public function executeFull()
    {
        return $this->_getSubject()->executeFull();
    }

    /**
     * {@inheritdoc}
     */
    public function executeList(array $orderIds)
    {
        return $this->_getSubject()->executeList($orderIds);
    }

    /**
     * {@inheritdoc}
     */
    public function executeRow($id)
    {
        return $this->_getSubject()->executeRow($id);
    }

    /**
     * {@inheritdoc}
     */
    public function addEmptyIndexByProductIds($ids)
    {
        return $this->_getSubject()->addEmptyIndexByProductIds($ids);
    }
}
