<?php
namespace Amasty\AdminActionsLog\Logging\DataStorage\BackendSession;

/**
 * Proxy class for @see \Amasty\AdminActionsLog\Logging\DataStorage\BackendSession
 */
class Proxy extends \Amasty\AdminActionsLog\Logging\DataStorage\BackendSession implements \Magento\Framework\ObjectManager\NoninterceptableInterface
{
    /**
     * Object Manager instance
     *
     * @var \Magento\Framework\ObjectManagerInterface
     */
    protected $_objectManager = null;

    /**
     * Proxied instance name
     *
     * @var string
     */
    protected $_instanceName = null;

    /**
     * Proxied instance
     *
     * @var \Amasty\AdminActionsLog\Logging\DataStorage\BackendSession
     */
    protected $_subject = null;

    /**
     * Instance shareability flag
     *
     * @var bool
     */
    protected $_isShared = null;

    /**
     * Proxy constructor
     *
     * @param \Magento\Framework\ObjectManagerInterface $objectManager
     * @param string $instanceName
     * @param bool $shared
     */
    public function __construct(\Magento\Framework\ObjectManagerInterface $objectManager, $instanceName = '\\Amasty\\AdminActionsLog\\Logging\\DataStorage\\BackendSession', $shared = true)
    {
        $this->_objectManager = $objectManager;
        $this->_instanceName = $instanceName;
        $this->_isShared = $shared;
    }

    /**
     * @return array
     */
    public function __sleep()
    {
        return ['_subject', '_isShared', '_instanceName'];
    }

    /**
     * Retrieve ObjectManager from global scope
     */
    public function __wakeup()
    {
        $this->_objectManager = \Magento\Framework\App\ObjectManager::getInstance();
    }

    /**
     * Clone proxied instance
     */
    public function __clone()
    {
        $this->_subject = clone $this->_getSubject();
    }

    /**
     * Get proxied instance
     *
     * @return \Amasty\AdminActionsLog\Logging\DataStorage\BackendSession
     */
    protected function _getSubject()
    {
        if (!$this->_subject) {
            $this->_subject = true === $this->_isShared
                ? $this->_objectManager->get($this->_instanceName)
                : $this->_objectManager->create($this->_instanceName);
        }
        return $this->_subject;
    }

    /**
     * {@inheritdoc}
     */
    public function get(string $key) : ?array
    {
        return $this->_getSubject()->get($key);
    }

    /**
     * {@inheritdoc}
     */
    public function set(string $key, array $data) : void
    {
        $this->_getSubject()->set($key, $data);
    }

    /**
     * {@inheritdoc}
     */
    public function unset(string $key) : void
    {
        $this->_getSubject()->unset($key);
    }

    /**
     * {@inheritdoc}
     */
    public function isExists(string $key) : bool
    {
        return $this->_getSubject()->isExists($key);
    }
}
