'use strict';

define([
    'jquery',
    'ko',
    'uiElement',
    'Magento_Catalog/js/price-utils'
], function ($, ko, Element, priceUtils) {
    return Element.extend({
        defaults: {
            template: 'Magento_Catalog/input-counter'
        },

        initObservable: function () {
            this._super()
                .observe('qty');

            return this;
        },

        getDataValidator: function() {
            return JSON.stringify(this.dataValidate);
        },

        decreaseQty: function() {
            var qty;

            if (this.qty() > 1) {
                qty = this.qty() - 1;
            } else {
                qty = 1;
            }
            var selectedOption = $('select.product-custom-option').val();
            var TotalQty = qty
            if(selectedOption){
                var json = $('select.product-custom-option').attr("data-qtyunitjson");
                var arr = $.parseJSON(json); //convert to javascript array
                $.each(arr,function(key,value){
                    if(selectedOption == key){
                        console.log(value.qty_option);
                        TotalQty = TotalQty * value.qty_option;
                    }
                })
            }
            var price = $('.price-final_price .price-container.price-final_price .price-wrapper').data("price-amount");
            var flprice = parseFloat(price) * parseFloat(TotalQty);
            var inPrice = priceUtils.formatPrice(flprice);
            jQuery("#product-addtocart-button .price-final_price .price-container .price-wrapper .price").text(inPrice)
            this.qty(qty);
        },

        increaseQty: function() {
            var qty = this.qty() + 1;
            var selectedOption = $('select.product-custom-option').val();
            var TotalQty = qty
            if(selectedOption){
                var json = $('select.product-custom-option').attr("data-qtyunitjson");
                var arr = $.parseJSON(json); //convert to javascript array
                $.each(arr,function(key,value){
                    if(selectedOption == key){
                        console.log(value.qty_option);
                        TotalQty = TotalQty * value.qty_option;
                    }
                })
            }
            var price = $('.price-final_price .price-container.price-final_price .price-wrapper').data("price-amount");
            var flprice = parseFloat(price) * parseFloat(TotalQty);
            var inPrice = priceUtils.formatPrice(flprice);
            jQuery("#product-addtocart-button .price-final_price .price-container .price-wrapper .price").text(inPrice)
            this.qty(qty);
        }
    });
});