<?php
declare(strict_types=1);

namespace Xtwo\wishlistApi\Api;

interface WishlistManagementInterface
{
    /**
     * @param int $customerId
     * @return \Xtwo\wishlistApi\Api\Data\WishlistInterface
     */
    public function get(int $customerId);

    /**
     * @param int $customerId
     * @param \Xtwo\wishlistApi\Api\Data\RequestInterface $item
     * @return \Xtwo\wishlistApi\Api\Data\WishlistInterface
     */
    public function add(int $customerId, $item);

    /**
     * @param int $customerId
     * @param int $itemId
     * @return bool
     */
    public function delete(int $customerId, int $itemId): bool;
}
