<?php

namespace Xtwo\WidgetApi\Model;

use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Store\Model\StoreManagerInterface;
use Xtwo\WidgetApi\Api\WidgetRepositoryInterface;
use Magento\Widget\Model\ResourceModel\Widget\Instance\CollectionFactory;
use Magento\Catalog\Model\ResourceModel\Product\CollectionFactory as ProductCollectionFactory;
use Magento\Wishlist\Model\WishlistFactory;
use Xtwo\CustomApis\Helper\Data as CustomApisHelper;
use Xtwo\AttributeOption\Helper\Image as ImageHelper;

class WidgetRepository implements WidgetRepositoryInterface
{
    protected $storeManager;
    protected $widgetCollectionFactory;
	protected $productCollectionFactory;
	protected $stockRegistry;
    protected $wishlistFactory;
    protected $customApisHelper;
    protected $imageHelper;
    protected $productrepository;

    public function __construct(
        StoreManagerInterface $storeManager,
        CollectionFactory $widgetCollectionFactory,
		\Magento\Catalog\Api\ProductRepositoryInterface $productrepository,
		 ProductCollectionFactory $productCollectionFactory,
		 \Magento\CatalogInventory\Api\StockRegistryInterface $stockRegistry,
         WishlistFactory $wishlistFactory,
         CustomApisHelper $customApisHelper,
		 \Magento\Tax\Model\Calculation $taxCalculation,
         ImageHelper $imageHelper,
    ) {
        $this->storeManager = $storeManager;
        $this->widgetCollectionFactory = $widgetCollectionFactory;
		$this->productrepository = $productrepository;
		$this->productCollectionFactory = $productCollectionFactory;
		$this->stockRegistry = $stockRegistry;
        $this->wishlistFactory = $wishlistFactory;
        $this->customApisHelper = $customApisHelper;
		$this->taxCalculation = $taxCalculation;
        $this->imageHelper = $imageHelper;
    }

    /**
     * {@inheritdoc}
     */
    public function getWidgetData($storeId, $widgetId, $customerId)
    {
            $store = $this->storeManager->getStore($storeId);
            $widgetCollection = $this->widgetCollectionFactory->create();
            $widgetCollection->addFieldToFilter('instance_id', $widgetId);
            $widgetCollection->addStoreFilter($store->getId());

            $widgetData = [];
			$widgetDataCollection = [];
            foreach ($widgetCollection as $widget) {
                $widgetData[]= $widget->getData();

				$widgetDataCollection['collection_widget']['instance_id'] = $widget->getInstanceId();
				$widgetDataCollection['collection_widget']['instance_type'] = $widget->getInstanceType();
				$widgetDataCollection['collection_widget']['theme_id'] = $widget->getThemeId();
				$widgetDataCollection['collection_widget']['title'] = $widget->getTitle();
				$widgetDataCollection['collection_widget']['store_id'] = $widget->getStoreIds();
				$widgetContentData = [];
					foreach ($widget->getWidgetParameters()['conditions'] as $parameter)
					{
						$widgetContentData = $parameter['value'];

					}
				$widgetDataCollection['collection_widget']['widget_parameter_sku'] = $widgetContentData;
				$skuData = $widgetContentData;
				$skuArray = explode(',', $skuData);
				$dataWidgetModified = [];

				foreach ($skuArray as $key=>$skuProduct)
				{
					$productCollection = $this->productCollectionFactory->create();
					$productCollection->addAttributeToSelect('*');
					$productCollection->addAttributeToFilter('sku',['in' => $skuProduct]);
					$productCollection->setStoreId($storeId); // Set store ID for the collection
					
					// Join with website table to ensure product is available in the specific store
					$productCollection->joinTable(
						'catalog_product_website',
						'product_id=entity_id',
						['website_id'],
						'website_id = ' . $this->storeManager->getStore($storeId)->getWebsiteId()
					);

					// Check if collection has products after filtering by store
					if ($productCollection->getSize() === 0) {
						continue; // Skip if no product is available for this store
					}
					
					foreach ($productCollection as $valueData) {
						
					// Calculate price with VAT
					$taxClassId = $valueData->getTaxClassId();
					$store      = $this->storeManager->getStore();
					$request = $this->taxCalculation->getRateRequest(null, null, null, $store);
					$taxRate = $this->taxCalculation->getRate($request->setProductClassId($taxClassId));
					
					$price = $valueData->getPrice();
					$price = round($price, 2);
					$basePrice = $price / 1.19;
					$priceWithTax = $basePrice + ($basePrice * ($taxRate / 100));
					
					$msrpPrice = $valueData->getMsrp();
					$msrpBasePrice = $msrpPrice / 1.19;
					$msrpPriceWithTax = $msrpBasePrice + ($msrpBasePrice * ($taxRate / 100));
					
                        $isInWishlist = false;
                        if (!empty($customerId)) {
                            $wishlist = $this->wishlistFactory->create()->loadByCustomerId($customerId, true);
                            $wishlistItems = $wishlist->getItemCollection();
                            foreach ($wishlistItems as $item) {
                                if ($item->getProductId() == $valueData->getId()) {
                                    $isInWishlist = true;
                                    break;
                                }
                            }
                        }
						$delivery = $valueData->getAttributeText('delivery_time');
						$showItem["id"] = $valueData->getId();
						$showItem["name"] = $valueData->getName();
						$showItem["image"] = $valueData->getImage();
						$showItem["sku"] = $valueData->getSku();
						$showItem["url_key"] = $valueData->getUrlKey();
						$showItem["price"] = (string)$priceWithTax;
						$showItem["weight"] = $valueData->getWeight();
						$productStock = $this->stockRegistry->getStockItem($valueData->getId());
						$stockItem = [
							'qty' => $productStock->getQty(),
							'is_in_stock' => $productStock->getIsInStock(),
						];
						$showItem["stock"] = $stockItem;
						$showItem["status"] = $valueData->getStatus();
						$showItem["visibility"] = $valueData->getVisibility();
						$showItem["type"] = $valueData->getTypeId();
						$showItem["meta_title"] = $valueData->getMetaTitle();
						$showItem["meta_description"] = $valueData->getMetaDescription();
						$showItem["delivery_time"] = $delivery;
						$showItem["msrp"] = (string)$msrpPriceWithTax;
                        $showItem["is_in_wishlist"] = $isInWishlist;
                        $showItem["product_rating"] = $this->customApisHelper->getAverageRating($valueData->getId());
                        $showItem["show_addtocart_button"] = $this->customApisHelper->getButtonStatus($valueData);
                        $layerImageOptionId = $valueData->getLayerImages();
                        $showItem["layerimage_path"] = $this->getLayerImagesPath($layerImageOptionId);
						$dataWidgetModified[] = $showItem;
					}

				}
				$widgetDataCollection['collection_widget']['product_count'] = $widget->getWidgetParameters()['products_count'];
				$widgetDataCollection['collection_widget']['sort_order'] = $widget->getSortOrder();
				$widgetDataCollection['collection_widget']['product_info'] = $dataWidgetModified;
            }
            return $widgetDataCollection;
    }

    private function getLayerImagesPath($optionId)
    {
        if ($this->imageHelper->getLayerImage($optionId)) {
            $imagePath = 'attributeoption/image/' . $this->imageHelper->getLayerImage($optionId);
            return $imagePath;
        }else{
            return '';
        }
    }
}
