<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Vatrate
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Vatrate\Model;


class Vatrate extends \Magento\Framework\Model\AbstractModel
{
/** @var array $rates local cache */
    private static $rates = null;
	protected $_customerSession;
	protected  $calculation;
	 public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
		\Magento\Store\Model\StoreManagerInterface $storeManager,
		\Magento\Customer\Model\Session $_customerSession,
		\Magento\Customer\Model\Customer $customer,
		\Magento\Tax\Model\Calculation $calculation,
		 \Magento\Checkout\Model\Cart $cart

	){
			$this->scopeConfig = $scopeConfig;
			$this->storeManager = $storeManager;
			$this->_customerSession=$_customerSession;
			$this->customer = $customer;
			$this->calculation = $calculation;
			$this->cart = $cart;
	}
	
	public function getRate() {
		$store = $this->storeManager->getStore();
		$shippingAdress = null;
		$billingAdress = null;
		$customerTaxClass = null;
		$quote = $this->_customerSession->getCustomer();
		
		if($this->_customerSession->isLoggedIn()){
			$customer_id = $this->_customerSession->getCustomer()->getId();
			$oCustomer = $this->customer->load($customer_id);
			$customerTaxClass = $oCustomer->getCustomerTaxClass();

		} else {
			$customerTaxClass = $quote->getCustomerTaxClassId();
		}
		
		
		$customerTaxClass = $quote->getCustomerTaxClassId();
		
		$shippingAdress = $quote->getShippingAddress();
		$billingAdress =  $quote->getBillingAddress();
		$address = $this->cart->getQuote()->getShippingAddress();
		
		$shippingAdress = $address;
		$billingAdress =  $address;
		$taxclassid = 2;
		$request = $this->calculation->getRateRequest($shippingAdress, $billingAdress, $customerTaxClass, $store);
		$percent = $this->calculation->getRate($request->setProductClassId($taxclassid));

		return $percent;
	}
}