<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\UpdatePrices\Setup;

use Magento\Framework\App\Config\ConfigResource\ConfigInterface;
use Magento\Framework\Setup\InstallDataInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;

/**
 * Class InstallData
 *
 * @package Core\UpdatePrices\Setup
 */
class InstallData implements InstallDataInterface
{
    /**
     * @var \Magento\Framework\App\Config\ConfigResource\ConfigInterface
     */
    private $configResourceModel;

    /**
     * InstallData constructor.
     * @param \Magento\Framework\App\Config\ConfigResource\ConfigInterface $configResourceModel
     */
    public function __construct(
        ConfigInterface $configResourceModel
    )
    {
        $this->configResourceModel = $configResourceModel;
    }

    /**
     * {@inheritdoc}
     */
    public function install(ModuleDataSetupInterface $setup, ModuleContextInterface $context)
    {

        $installer = $setup;
        $installer->startSetup();

//        $configValues = [
//            1 => 1.00,
//            2 => 1.05,
//            3 => 1.0675,
//            4 => 1.1,
//            5 => 1.00,
//            6 => 1.00,
//            7 => 1.0375,
//            8 => 1.08,
//            9 => 1.1,
//            10 => 1.1,
//            11 => 1.1,
//            12 => 1.1,
//            13 => 1.06,
//            14 => 1.07,
//            15 => 1.08,
//            16 => 1.08,
//            17 => 1.08,
//            18 => 1.08,
//            20 => 1.10,
//            23 => 1.15,
//            24 => 1.15,
//            25 => 1.15,
//            26 => 1.15,
//            27 => 1.15,
//            28 => 1.15,
//            29 => 1.15,
//            38 => 1.00
//        ];
//
//        foreach ($configValues as $websiteId => $value) {
//            $this->configResourceModel->saveConfig(
//                'catalog/store_prices/multiplier', $value, 'websites', $websiteId
//            );
//        }
//
//        $skuValue = <<<TEXT
//23335000#1.00
//23341000#1.00
//38732SH0#1.00
//26268LV0#1.00
//3855800M#1.00
//27799000#1.00
//28364000#1.00
//53604501#1.00
//536045R1#1.00
//TEXT;
//        $this->configResourceModel->saveConfig(
//            'catalog/store_prices/multiplier_sku', $skuValue, 'websites', 1
//        );
//        $skuValue = <<<TEXT
//260 1000 S#1.0376
//260 1010 S1#1.0376
//100 1000 S#1.0684
//100 1010 S#1.0684
//100 1500 S#1.0561
//100 1824 S#1.0726
//100 2500 S#1.1183
//100 1300 S#1.0597
//100 1700 S#1.0449
//100 1162 S#1.0198
//100 1220 S#1.0539
//100 1100 S#1.0449
//100 2103 S#1.0787
//100 4123 1 S#1.0393
//100 1686 S#1.0588
//100 7910 S#1.0990
//100 2721 S#1.0146
//100 1601 S#1.0684
//100 1650 S#1.1262
//100 1670 S#1.0918
//100 1660 S#1.2894
//100 1640 S#1.4178
//100 1696 S#1.1254
//100 1693 S#1.2280
//360 2000 76#1.0134
//360 2000 77#1.0134
//TEXT;
//        $this->configResourceModel->saveConfig(
//            'catalog/store_prices/multiplier_sku', $skuValue, 'websites', 5
//        );
//        $skuValue = <<<TEXT
//260 1000 S#1.0903
//260 1010 S1#1.0903
//100 1000 S#1.1641
//100 1010 S#1.1641
//100 1500 S#1.1347
//100 1824 S#1.1742
//100 2500 S#1.2838
//100 1300 S#1.1433
//100 1700 S#1.1077
//100 1162 S#1.0475
//100 1220 S#1.1293
//100 1100 S#1.1077
//100 2103 S#1.1888
//100 4123 1 S#1.0942
//100 1686 S#1.1410
//100 7910 S#1.2375
//100 2721 S#1.0350
//100 1601 S#1.1641
//100 1650 S#1.3028
//100 1670 S#1.2201
//100 1660 S#1.6943
//100 1640 S#2.0024
//100 1696 S#1.3008
//100 1693 S#1.5469
//360 2000 76#1.0322
//360 2000 77#1.0322
//TEXT;
//        $this->configResourceModel->saveConfig(
//            'catalog/store_prices/multiplier_sku', $skuValue, 'websites', 11
//        );
//        $this->configResourceModel->saveConfig(
//            'catalog/store_prices/multiplier_set', "Badmöbel#1.12", 'websites', 2
//        );
//        $this->configResourceModel->saveConfig(
//            'catalog/store_prices/multiplier_serie', "Lineare#1.05", 'websites', 8
//        );
//        $multiplierLowprice = [
//            2 => "0.00-20.00#1.30\n20.01-50.00#1.25",
//            3 => "0.00-20.00#1.35\n20.01-50.00#1.30",
//            4 => "0.00-20.00#1.35",
//            5 => "0.00-20.00#1.30\n20.01-50.00#1.25",
//            6 => "0.00-20.00#1.20\n20.01-50.00#1.15",
//            7 => "0.00-20.00#1.30\n20.01-50.00#1.25"
//        ];
//        foreach ($multiplierLowprice as $websiteId => $value) {
//            $this->configResourceModel->saveConfig(
//                'catalog/store_prices/multiplier_lowprice',
//                $value,
//                'websites',
//                $websiteId
//            );
//        }
//
//        $multiplierBrandValue = <<<TEXT
//Grohe#1.0225
//Hansgrohe#1.0225
//Ideal Standard#1.0275
//Duravit#1.0275
//Villeroy & Boch#1.0225
//Dresta#0.9
//TEXT;
//
//        $multiplierBrandValues = [
//            2 => "Grohe#1.0475\nHansgrohe#1.0425\nDuravit#1.04",
//            3 => "GROHE#1.0775\nHansgrohe#1.0475\nDuravit#1.0325\nVilleroy & Boch#1.0325",
//            5 => "Dresta#0.9",
//            6 => "GROHE#0.90\nHansgrohe#0.90\nDuravit#0.90\nVilleroy & Boch#0.90",
//            7 => $multiplierBrandValue
//        ];
//
//        foreach ($multiplierBrandValues as $websiteId => $value) {
//            $this->configResourceModel->saveConfig(
//                'catalog/store_prices/multiplier_brand', $value, 'websites', $websiteId
//            );
//        }

        $installer->endSetup();
    }
}
