<?php

namespace Xtwo\Support\Observer;

use Magento\Framework\Event\ObserverInterface;
use Psr\Log\LoggerInterface;
use Magento\Framework\Mail\Template\TransportBuilder;
use Magento\Framework\DataObject;

class Orderplaceafter implements ObserverInterface
{
    protected $logger;

    public function __construct(
        LoggerInterface $logger,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
		TransportBuilder $transportBuilder
        ){
        $this->logger = $logger;
        $this->scopeConfig = $scopeConfig;
		$this->transportBuilder= $transportBuilder;
    }

    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        try {
            $order = $observer->getEvent()->getOrder();
            $storeId = $order->getStoreId();

            $vatEmailTemplate= $this->scopeConfig->getValue( 
                'support/vat/email_template_vat', 
                \Magento\Store\Model\ScopeInterface::SCOPE_STORE, 
             );
			 $this->logger->info('vat order '.json_encode($vatEmailTemplate));
			 $this->logger->info('vat order tax amount'.json_encode($order->getTaxAmount()));
             if ($vatEmailTemplate != '') {
                if ($order->getTaxAmount() == 0) {
                    $subject = $this->scopeConfig->getValue( 
                        'support/vat/subject_vat', 
                        \Magento\Store\Model\ScopeInterface::SCOPE_STORE, 
                     );
                    $templateId = $this->scopeConfig->getValue( 
                        'support/vat/email_template_vat', 
                        \Magento\Store\Model\ScopeInterface::SCOPE_STORE, 
                     );
                    $this->sendEmail($order, $templateId, $subject, 'ORDER_WITH_VAT');
                }
            }
        } catch (\Exception $e) {
            $this->logger->info($e->getMessage());
        }
    }
    private function sendEmail($order, $templateId, $subject, $type, $additionalParams=array(), $notifyCustomer=false) {
        //Variables for Confirmation Mail.
        $storeId = $order->getStoreId();
    	$emailTemplateVariables = array();
        $emailTemplateVariables['order'] = $order;

        $emails = $this->scopeConfig->getValue( 
            'support/general/email_address', 
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
            $order->getStoreId()
         );
        $emails = explode(',', $emails);
        if ($notifyCustomer) {
            array_push($emails, $order->getCustomerEmail());
        }
        $senderName = $this->scopeConfig->getValue( 
            'trans_email/email_support/email_support_name', 
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
         );
         $senderEmail = $this->scopeConfig->getValue( 
            'trans_email/email_support/email_support_address', 
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
         );
		 
		 
		 $senderEmailArray= ['email'=>$senderEmail,'name'=>$senderName];
		 
		 $transport = [
			'order'   => $order,
            'comment' => $order->getEmailCustomerNote(),
            //'customer' => $customer,
            'billing' => $order->getBillingAddress(),
            //'payment_html' => $paymentBlockHtml
		 ];
		 $transportObject = new DataObject($transport);
         $transport = $this->transportBuilder
                ->setTemplateIdentifier(
                    $templateId, 
                    \Magento\Store\Model\ScopeInterface::SCOPE_STORE)
                ->setTemplateOptions([
                    'area' => \Magento\Framework\App\Area::AREA_FRONTEND,
                    'store' => $storeId
                ])
                ->setTemplateVars($transportObject->getData())
                ->setFrom($senderEmailArray);
         if (is_array($emails)) {
            
            foreach ($emails as $rec) {
                
                $transport->addTo($rec);
            }
        } else {
            $transport->addTo($emails);
        }
		//++++++++++++++++
		 $emailReplyTo = $this->scopeConfig->getValue( 
            'trans_email/email_support/email_reply_to', 
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
         );
		 if(!empty($emailReplyTo)){
			 $transport->setReplyTo($emailReplyTo);
		 }
		 //++++++++++++++++
        $transport=$transport->getTransport();
        try{         
            $transport->sendMessage();
        }catch(\Exception $e){
           $this->logger->info($e->getMessage());
        }
    }
}