<?php

namespace Xtwo\Support\Observer;

use Magento\Framework\Event\ObserverInterface;
use Psr\Log\LoggerInterface;
use Magento\Sales\Model\Order;
use Magento\Sales\Api\InvoiceRepositoryInterface;

class CheckPayonePayment implements ObserverInterface
{
    protected $logger;

    public function __construct(
        LoggerInterface $logger,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
		\Magento\Sales\Api\OrderManagementInterface $orderManagement,
		\Magento\Framework\App\ResourceConnection $resourceConnection,
		Order $order,
		InvoiceRepositoryInterface $invoiceRepository,
        )
    {
        $this->logger = $logger;
        $this->scopeConfig = $scopeConfig;
		$this->orderManagement = $orderManagement;
		$this->resourceConnection = $resourceConnection;
		$this->order = $order;
		$this->invoiceRepository = $invoiceRepository;
    }

    public function execute(\Magento\Framework\Event\Observer $observer)
    {
		$eventName= $observer->getEvent()->getName();
		$this->logger->info('event name in observer'.json_encode( $eventName));
		$invoice = $observer->getEvent()->getOrder();
		$order =$observer->getEvent()->getOrder();;
		$this->logger->info('order in observer'.json_encode( $order));
		$orderIncrementId = $order->getIncrementId();
		$payment = $order->getPayment();
		$paymentMethod = $payment->getMethod();
		$this->logger->info('payment'.json_encode($payment->getMethod()));
        //$this->logger->info('invoice - order incrementId'.json_encode($orderIncrementId));
		$connection = $this->resourceConnection->getConnection();
		$orderId = $order->getId();
		$orderObj = $this->order->load($orderId);
		$this->logger->info("orderId".$orderId);
		$invoice = $order->getInvoiceCollection();
		$this->logger->info('invoice'.json_encode($invoice));

		if($paymentMethod =='payone_creditcard'){
				
			$table = $connection->getTableName('payone_protocol_transactionstatus');
			$query = "SELECT * FROM " . $table . " WHERE order_id ='".$orderIncrementId."' and txaction= 'failed' LIMIT 0,1";
			$this->logger->info($query);
			$payoneTSResult = $connection->fetchOne($query);
			$this->logger->info('payone_protocol_transactionstatus'.json_encode($payoneTSResult));
			if($payoneTSResult){
				try{
					$order->setState(\Magento\Sales\Model\Order::STATE_CANCELED, true);
					$order->setStatus(\Magento\Sales\Model\Order::STATE_CANCELED);
					$order->addStatusToHistory($order->getStatus(), 'Order canceled due to payone failed payment');
					//$order->save();
					$this->orderManagement->cancel($orderId);

					$orderInvoices = $order->getInvoiceCollection();
				
					foreach($orderInvoices as $iK=> $orderInvoice){
						
						$invoice = $this->invoiceRepository->get($orderInvoice['entity_id']);
						$invoice->setState(\Magento\Sales\Model\Order\Invoice::STATE_CANCELED);
						$this->invoiceRepository->save($invoice);
						$order->addStatusToHistory($order->getStatus(), 'Order invoice due to payone failed payment');
						
						$this->logger->info('observer order invoice # '.$orderInvoice['entity_id'].' payment with '.$paymentMethod.' failed so order cancelled');
					}
					$order->save();
					$this->logger->info('observer order # '.$orderIncrementId.' payment with '.$paymentMethod.' failed so order cancelled');
				}catch(\Exception $e){
					$this->logger->info('observer order # '.$orderIncrementId.' payment with '.$paymentMethod.' unable to cancel due to this reason-'.$e->getMessage());
				}
			}
		}
    }
}