<?php

namespace Xtwo\Support\Observer;

use Magento\Framework\Event\ObserverInterface;
use Psr\Log\LoggerInterface;
use Magento\Sales\Model\Order;

class CheckInvoice implements ObserverInterface
{
    protected $logger;

    public function __construct(
        LoggerInterface $logger,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
		\Magento\Sales\Api\OrderManagementInterface $orderManagement,
		\Magento\Framework\App\ResourceConnection $resourceConnection,
		Order $order
        )
    {
        $this->logger = $logger;
        $this->scopeConfig = $scopeConfig;
		$this->orderManagement = $orderManagement;
		$this->resourceConnection = $resourceConnection;
		$this->order = $order;
    }

    public function execute(\Magento\Framework\Event\Observer $observer)
    {
		$eventName= $observer->getEvent()->getName();
		$this->logger->info('event name in observer'.json_encode( $eventName));
		$invoice = $observer->getEvent()->getOrder();
		$order =$observer->getEvent()->getOrder();;
		$this->logger->info('order in observer'.json_encode( $order));
		$orderIncrementId = $order->getIncrementId();
		$payment = $order->getPayment();
		$paymentMethod = $payment->getMethod();
		$this->logger->info('payment'.json_encode($payment->getMethod()));
        $this->logger->info('invoice - order incrementId'.json_encode($orderIncrementId));
		$connection = $this->resourceConnection->getConnection();
		$orderId = $order->getId();
		$orderObj = $this->order->load($orderId);
		$this->logger->info("orderId".$orderId);

		if($paymentMethod =='payone_creditcard'){
				
			$table = $connection->getTableName('payone_protocol_transactionstatus');
			$query = "SELECT * FROM " . $table . " WHERE order_id ='".$orderIncrementId."' and txaction= 'failed' LIMIT 0,1";
			$this->logger->info($query);
			$payoneTSResult = $connection->fetchOne($query);
			$this->logger->info('payone_protocol_transactionstatus'.json_encode($payoneTSResult));
			if($payoneTSResult){
				try{
					$order->setState(\Magento\Sales\Model\Order::STATE_CANCELED, true);
					$order->setStatus(\Magento\Sales\Model\Order::STATE_CANCELED);
					$order->addStatusToHistory($order->getStatus(), 'Order canceled due to payone failed payment');
					$order->save();
					$this->orderManagement->cancel($orderId);
					$this->logger->info('observer order # '.$orderIncrementId.' payment with '.$paymentMethod.' failed so order cancelled');
				}catch(\Exception $e){
					$this->logger->info('observer order # '.$orderIncrementId.' payment with '.$paymentMethod.' unable to cancel due to this reason-'.$e->getMessage());
				}
			}
		}
    }
}