<?php
namespace Xtwo\Support\Model;

use Psr\Log\LoggerInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Magento\Sales\Model\ResourceModel\Order\CollectionFactory as OrderCollectionFactory;
use Magento\Sales\Api\InvoiceRepositoryInterface;

class PayoneFailedPayment {
    protected $logger;
    public function __construct(
		LoggerInterface $logger,
		OrderCollectionFactory $orderCollectionFactory,
		\Magento\Sales\Api\Data\OrderInterface $order,
		\Magento\Framework\App\ResourceConnection $resourceConnection,
		\Magento\Sales\Api\OrderManagementInterface $orderManagement,
		InvoiceRepositoryInterface $invoiceRepository,
	){
        $this->logger = $logger;
		$this->orderCollectionFactory = $orderCollectionFactory;
		$this->order = $order;
		$this->resourceConnection = $resourceConnection;
		$this->orderManagement = $orderManagement;
		$this->invoiceRepository = $invoiceRepository;
    }
   /**
    * Write to system.log
    *
    * @return void
    */
    public function cancelOrder( ) {
		$this->logger->info('payment failed cron running');
		$lastDateTime = date('Y-m-d H:i:s',strtotime("-2 minutes"));
		$orders = $this->orderCollectionFactory->create()
		->addFieldToFilter('created_at',['gteq' => '2024-04-03 00:00:00'])
		->addFieldToFilter('created_at',['lteq' => $lastDateTime])
		//->addFieldToFilter('created_at',['gteq' => date('Y-m-d',strtotime("-1 days"))])
		->addFieldToFilter('nav_no',array('null' => true))
		->addFieldToFilter('status',array('in' => array('pending','processing')))
		//->addFieldToFilter('increment_id',array('in' => array('100056902')))															  
		->addAttributeToSort('created_at', 'DESC')
		->setPageSize(10)
		->getData();
        $result = [];
		//dd($orders);
		$this->logger->info('payone failed cron'.json_encode($orders));
		foreach ($orders as $key=>$order) {
			
			$order= $this->order->load($order['entity_id']);
			$orderIncrementId = $order->getIncrementId();
			$payment = $order->getPayment();
			$paymentMethod = $payment->getMethod();
			$orderId = $order->getId();
			//dd($paymentMethod);
			
			if($order['status']=='processing' || $order['status']=='pending'){
				
				if($paymentMethod =='payone_creditcard'){
					
					$connection = $this->resourceConnection->getConnection();
					$table = $connection->getTableName('payone_protocol_transactionstatus');
					//--------no records in table cancel the order------//
					$query = "SELECT * FROM " . $table . " WHERE order_id ='".$orderIncrementId."'  LIMIT 0,1";
					$this->logger->info($query);
					$payoneTSResult = $connection->fetchOne($query);
					$this->logger->info('payone_protocol_transactionstatus'.json_encode($payoneTSResult));
					
					if(empty($payoneTSResult)){
						
						try{
							$order->setState(\Magento\Sales\Model\Order::STATE_CANCELED, true);
							$order->setStatus(\Magento\Sales\Model\Order::STATE_CANCELED);
							$order->addStatusToHistory($order->getStatus(), 'Order canceled due to payone failed payment (no records in transaction status )');
							//$order->save();
							$this->orderManagement->cancel($orderId);
							$orderInvoices = $order->getInvoiceCollection();
						
							foreach($orderInvoices as $iK=> $orderInvoice){
								
								$invoice = $this->invoiceRepository->get($orderInvoice['entity_id']);
								$invoice->setState(\Magento\Sales\Model\Order\Invoice::STATE_CANCELED);
								$this->invoiceRepository->save($invoice);
								$order->addStatusToHistory($order->getStatus(), 'Order invoice due to payone failed payment (no records in transaction status )');
								
								$this->logger->info('observer order invoice # '.$orderInvoice['entity_id'].' payment with '.$paymentMethod.' failed so order cancelled (no records in transaction status )');
							}
							$order->save();
							$this->logger->info('observer order # '.$orderIncrementId.' payment with '.$paymentMethod.' failed so order cancelled (no records in transaction status )');
						}catch(\Exception $e){
							$this->logger->info('observer order # '.$orderIncrementId.' payment with '.$paymentMethod.' unable to cancel due to this reason-'.$e->getMessage());
						}
					}
					//--------no records in table cancel the order------//
				}
			}
		}
    }
}