<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Stockmanage
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */
namespace Xtwo\Stockmanage\Plugin;
 
class Product
{
    const XML_PATH_DEL_TIME = 'stockmanage/static/delivery_times';
    const XML_PATH_DEL_CUSTOM = 'stockmanage/static/custom';


   public function __construct(\Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig)
   {
      $this->scopeConfig = $scopeConfig;
   }


    /**
     * after isSalable
     * @param \Magento\Catalog\Model\Product $subject,$result
     * @return boolean true false
     */

    public function afterIsSalable(
        \Magento\Catalog\Model\Product $subject,
        $result
    ) { 
        $storeScope = \Magento\Store\Model\ScopeInterface::SCOPE_STORE;
        $spec_time = $this->scopeConfig->getValue(self::XML_PATH_DEL_TIME, $storeScope);

        $spec_time = $this->scopeConfig->getValue(self::XML_PATH_DEL_TIME, $storeScope);
        $spec_custom = $this->scopeConfig->getValue(self::XML_PATH_DEL_CUSTOM, $storeScope);
        
        
        $deltime = $subject->getData('delivery_time');      

        
        $exp = explode(',',$spec_custom);
        $cnt  = count($exp);

        if($cnt > 0 && !is_null($spec_custom)){        
            if(in_array($deltime,$exp) && $spec_time == 'delivery_time'){
                return false;
            }
        }
        
        return true;
    }
}