<?php

namespace Xtwo\Sitemap\Model;

use MageWorx\XmlSitemap\Model\Writer as MageWorxWriter;

class Writer extends MageWorxWriter
{
    /**
     * Override the write method to remove 'pub' from the generated sitemap URLs.
     *
     * @param string $rawUrl
     * @param string $lastmod
     * @param string $changefreq
     * @param string $priority
     * @param \Magento\Framework\DataObject|false $imageUrls
     * @param \Magento\Framework\DataObject|false $videoUrls
     * @return void
     */
    protected function generateSitemapIndex(): void
    {
        if (!$this->useIndex) {
            return;
        }

        $this->openPathAndFileExist();

        $this->stream = $this->directory->openFile($this->fileName, 'w+');
        $this->stream->write('<?xml version="1.0" encoding="UTF-8"?>' . "\n");
        $this->stream->write('<sitemapindex xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">');

        $date = $this->date->gmtDate('Y-m-d');
        $i    = $this->sitemapInc;

        for ($this->sitemapInc = 1; $this->sitemapInc <= $i; $this->sitemapInc++) {
            $fileName = $this->getSitemapFilename();
            $urlPart  = ltrim(str_replace(trim($this->serverPath, '/') . '/', '/', $this->fileDir), '/');

            // Remove "pub" from the URL part if present
            $urlPart = str_replace('pub/', '', $urlPart);

            $urls['store_url'] = $this->getStoreBaseUrl() . $urlPart . $fileName;

            $store = $this->storeManager->getStore();
            if ($store->isUseStoreInUrl()) {
                $urls['no_store_code_url'] = str_replace($store->getCode() . '/', '', $urls['store_url']);
            }

            $urls['base_url'] = $this->getStoreBaseUrl() . ltrim($this->fileDir, '/') . $fileName;

            // Remove "pub" from the base URL if present
            $urls['base_url'] = str_replace('pub/', '', $urls['base_url']);

            if ($this->helper->isCheckUrlsAvailability() && empty($validKey)) {
                $validKey = $this->linkChecker->checkUrls($urls, $store->getId());
            }

            if (empty($validKey)) {
                $validKey = 'base_url';
            }

            $url = $urls[$validKey];

            $xml = sprintf(
                '<sitemap><loc>%s</loc><lastmod>%s</lastmod></sitemap>',
                htmlspecialchars($url),
                $date
            );
            $this->stream->write($xml);
        }

        $this->sitemapInc = $i;

        $this->stream->write('</sitemapindex>');
        $this->stream->close();

        $this->moveFileFromTempToOriginal($this->fileName);
    }
}
