<?php
namespace Xtwo\Sitemap\Model;

use Magento\Catalog\Model\ResourceModel\Category\CollectionFactory as CategoryCollectionFactory;
use Magento\Cms\Model\ResourceModel\Page\CollectionFactory as PageCollectionFactory;
use Xtwo\Sitemap\Api\SitemapLinksInterface;
use Magento\Store\Model\StoreManagerInterface;

class SitemapLinks implements SitemapLinksInterface
{
    protected $categoryCollectionFactory;
    protected $pageCollectionFactory;
    protected $storeManager;

    public function __construct(
        CategoryCollectionFactory $categoryCollectionFactory,
        PageCollectionFactory $pageCollectionFactory,
        StoreManagerInterface $storeManager
    ) {
        $this->categoryCollectionFactory = $categoryCollectionFactory;
        $this->pageCollectionFactory = $pageCollectionFactory;
        $this->storeManager = $storeManager;
    }

    /**
     * Retrieve category and page links based on store ID.
     *
     * @param int $storeId
     * @return array
     */
    public function getLinks($storeId)
    {
        $links = [];
    
        $mainCategoryCollection = $this->getMainCategories($storeId);
        foreach ($mainCategoryCollection as $category) {
            if ($category->getLevel() == 2) { 
                $links['Catalogue'][] = [
                    'name' => $category->getName(),
                    'url_key'  => '/category/' . $category->getUrlKey(),
                    'subcategories' => $this->getSubcategoriesLevel3($category->getId(),$category->getUrlKey())
                ];
            }
        }
    
        return [$links];
    }  
    
    protected function getSubcategoriesLevel3($mainCatId, $mainCatUrl)
    {
        $subcategoryCollection = $this->categoryCollectionFactory->create();
        $subcategoryCollection->addAttributeToSelect(['name', 'url_key', 'is_active','parent_id','level','in_html_sitemap'])
            ->addIsActiveFilter() 
            ->addAttributeToFilter('is_active', 1)
            ->addAttributeToFilter('parent_id', $mainCatId) 
            ->addAttributeToFilter('in_html_sitemap', 1)
            ->addAttributeToFilter('level', 3); 

        $subcategories = [];
        foreach ($subcategoryCollection as $subcategory) {
            $subcategories[] = [
                'name' => $subcategory->getName(),
                'url_key'  => '/category/' . $mainCatUrl . '/' . $subcategory->getUrlKey(),
                'subcategories' => $this->getSubcategoriesLevel4($subcategory->getId(),$mainCatUrl,$subcategory->getUrlKey())
            ];
        }

        return $subcategories;
    }

    protected function getSubcategoriesLevel4($subCatId,$mainCatUrl,$subCatUrl)
    {
        $subSubcategoryCollection = $this->categoryCollectionFactory->create();
        $subSubcategoryCollection->addAttributeToSelect(['name', 'url_key', 'is_active','parent_id','level','in_html_sitemap'])
            ->addIsActiveFilter() 
            ->addAttributeToFilter('is_active', 1)
            ->addAttributeToFilter('parent_id', $subCatId) 
            ->addAttributeToFilter('in_html_sitemap', 1)
            ->addAttributeToFilter('level', 4); 

        $subSubcategories = [];
        foreach ($subSubcategoryCollection as $subSubcategory) {
            $subSubcategories[] = [
                'name' => $subSubcategory->getName(),
                'url_key'  => '/category/' . $mainCatUrl . '/' . $subCatUrl.'/'.$subSubcategory->getUrlKey(),
                'subcategories' => []
            ];
        }

        return $subSubcategories;
    }

    
    protected function getMainCategories($storeId)
    {
        $rootCategoryId = $this->storeManager->getStore($storeId)->getRootCategoryId();
        $categoryCollection = $this->categoryCollectionFactory->create();
        $categoryCollection->setStore($storeId)
            ->addAttributeToSelect(['name', 'url_key', 'is_active','parent_id','level'])
            ->addIsActiveFilter() 
            ->addAttributeToFilter('is_active', 1) 
            ->addAttributeToFilter('parent_id', $rootCategoryId) 
            ->addAttributeToFilter('level', 2);

        return $categoryCollection;
    }
}
