<?php
 
namespace Xtwo\Sitemap\Model\Generator;
 
use MageWorx\XmlSitemap\Model\Generator\Product as BaseProduct;
use Magento\Framework\Event\ManagerInterface as EventManagerInterface;
use Magento\Framework\Exception\LocalizedException;
use MageWorx\XmlSitemap\Model\ResourceModel\Catalog\ProductFactory;
use MageWorx\XmlSitemap\Helper\Data as Helper;
use Magento\Framework\ObjectManagerInterface;
use Magento\Framework\DataObject;
use MageWorx\XmlSitemap\Model\WriterInterface;
use Zend_Db_Statement_Exception;
use Magento\Store\Model\StoreManagerInterface;
 
class Product extends BaseProduct
{
    /**
     * @var StoreManagerInterface
     */
    protected $storeManager;
 
    /**
     * Product constructor.
     *
     * @param Helper $helper
     * @param ObjectManagerInterface $objectManager
     * @param ProductFactory $sitemapProductResourceFactory
     * @param EventManagerInterface $eventManager
     * @param StoreManagerInterface $storeManager
     */
    public function __construct(
        Helper $helper,
        ObjectManagerInterface $objectManager,
        ProductFactory $sitemapProductResourceFactory,
        EventManagerInterface $eventManager,
        StoreManagerInterface $storeManager
    ) {
        parent::__construct($helper, $objectManager, $sitemapProductResourceFactory, $eventManager);
        $this->storeManager = $storeManager;
    }
 
    protected function getItemUrl($item)
    {
        $store = $this->storeManager->getStore($this->storeId);
        $storeUrl = $store->getBaseUrl();
        $urlKey = $item->getUrl();
        $urlKey = str_replace('.html', '', $urlKey);
        $url = $storeUrl . 'product/' . $urlKey;
        return $this->helper->trailingSlash($url);
    }
}