<?php
namespace Xtwo\Sitemap\Model\Generator;
 
use MageWorx\XmlSitemap\Model\Generator\Category as BaseCategory;
use Magento\Framework\Event\ManagerInterface as EventManagerInterface;
use Magento\Framework\Exception\LocalizedException;
use MageWorx\XmlSitemap\Model\ResourceModel\Catalog\CategoryFactory;
use MageWorx\XmlSitemap\Helper\Data as Helper;
use Magento\Framework\ObjectManagerInterface;
use Magento\Framework\DataObject;
use MageWorx\XmlSitemap\Model\WriterInterface;
use Magento\Store\Model\StoreManagerInterface;
 
class Category extends BaseCategory
{
    /**
     * @var StoreManagerInterface
     */
    protected $storeManager;
 
    /**
     * Category constructor.
     *
     * @param Helper $helper
     * @param ObjectManagerInterface $objectManager
     * @param CategoryFactory $categoryFactory
     * @param EventManagerInterface $eventManager
     * @param StoreManagerInterface $storeManager
     */
    public function __construct(
        Helper $helper,
        ObjectManagerInterface $objectManager,
        CategoryFactory $categoryFactory,
        EventManagerInterface $eventManager,
        StoreManagerInterface $storeManager
    ) {
        parent::__construct($helper, $objectManager, $categoryFactory, $eventManager);
        $this->storeManager = $storeManager;
    }
 
    /**
     * @param DataObject $item
     * @return string
     */
    protected function getItemUrl($item)
    {
        $store = $this->storeManager->getStore($this->storeId);
        $storeUrl = $store->getBaseUrl();
        $urlKey = $item->getUrl();
        $urlKey = str_replace('.html', '', $urlKey);
        $url = $storeUrl . 'category/' . $urlKey;
        return $this->helper->trailingSlash($url);
    }
}