<?php
 
namespace Xtwo\Shippingtablerate\Helper;
 
 
class Data extends \Magento\Framework\App\Helper\AbstractHelper
{
    const multifee_value = 'carriers/shippingtablerate/multifee_value';
    const spedition_weight_min = 'carriers/shippingtablerate/spedition_weight_min';

    const spedition_weight_max = 'carriers/shippingtablerate/spedition_weight_max';

    const de_shippingfree_countries = 'carriers/shippingtablerate/de_shippingfree_countries';

    const de_shippingfree_countries_value = 'carriers/shippingtablerate/de_shippingfree_countries_value';
   
    const de_shippingfree_value = 'carriers/shippingtablerate/de_shippingfree_value';

    const additional_info = 'carriers/shippingtablerate/additional_info';
 
    /**
     * @param \Magento\Framework\App\Helper\Context $context
     */
    public function __construct(
        \Magento\Framework\App\Helper\Context $context
    ) {
        parent::__construct($context);
    }
 
 
    public function getMultifeeValue()
    {
        return $this->scopeConfig->getValue(
            self::multifee_value,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }
 
    public function getSpeditionWeightMin()
    {
        return $this->scopeConfig->getValue(
            self::spedition_weight_min,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }


    public function getSpeditionWeightMax()
    {
        return $this->scopeConfig->getValue(
            self::spedition_weight_mx,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    public function getDeShippingfreeCountries()
    {
        return $this->scopeConfig->getValue(
            self::de_shippingfree_countries,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    public function getDeShippingfreeCountriesValue()
    {
        return $this->scopeConfig->getValue(
            self::de_shippingfree_countries_value,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }


    public function getDeShippingfreeValue()
    {
        return $this->scopeConfig->getValue(
            self::de_shippingfree_value,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    public function getAdditionalInfo()
    {
        return $this->scopeConfig->getValue(
            self::additional_info,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

}