<?php 
namespace Xtwo\Shippingtablerate\Block\Widget;

use Magento\Framework\View\Element\Template;
use Magento\Widget\Block\BlockInterface; 
use Psr\Log\LoggerInterface;
use Magento\Store\Model\ScopeInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;

class Tablerates extends Template implements BlockInterface {

const COUNTRY_CODE_PATH = 'general/country/default';

public function __construct(\Magento\Framework\View\Element\Template\Context $context, 
\Magento\Store\Model\StoreManagerInterface $storeManager, 
\Magento\OfflineShipping\Model\ResourceModel\Carrier\Tablerate\CollectionFactory $tablerates,
\Magento\Directory\Model\CountryFactory $countryFactory,
\Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
\Magento\Framework\App\ResourceConnection $resourceConnection,
\Magento\Framework\Pricing\Helper\Data $priceHelper,
LoggerInterface $loggerInterface,
\Magento\Directory\Helper\Data $directoryHelper,

\Xtwo\Shippingtablerate\Helper\Data $tblDataHelper
){
    $this->storeManager = $storeManager;  
    $this->tablerates = $tablerates;
    $this->_countryFactory = $countryFactory;  
    $this->scopeConfig = $scopeConfig; 
    $this->resourceConnection = $resourceConnection;
    $this->priceHelper = $priceHelper;
    $this->tblDataHelper = $tblDataHelper;
    $this->logger = $loggerInterface;
    $this->_directoryHelper = $directoryHelper;

    parent::__construct($context);
    $this->setTemplate("widget/tablerates.phtml");
}
    public function getConnection(){
        return  $this->resourceConnection->getConnection(\Magento\Framework\App\ResourceConnection::DEFAULT_CONNECTION);
    }  
    public function getWelcomeText(){
        return '';
    }

    public function getWebsiteId(){ 
        return $this->storeManager->getStore()->getWebsiteId();
    }

    public function tablerates($country){
        $this->logger->info('website'.$this->getWebsiteId().'Country'.$country);
        if($country == ''){
            return $this->tablerates->create()->setWebsiteFilter($this->getWebsiteId());
        } else {
            return $this->tablerates->create()->setWebsiteFilter($this->getWebsiteId())->setCountryFilter($country);
        }
    }
    public function getCountryname($countryCode){    
        $country = $this->_countryFactory->create()->loadByCode($countryCode);
        return $country->getName();
    }

    public function getStoreConf($path){ 
        return $this->scopeConfig->getValue($path,\Magento\Store\Model\ScopeInterface::SCOPE_STORE,$this->storeManager->getStore()->getStoreId());
    }

    public function getCountryByWebsite(){
        return $this->scopeConfig->getValue(
            self::COUNTRY_CODE_PATH,
            ScopeInterface::SCOPE_WEBSITES
        );
    }
    public function getTableName($name){  
        $this->resourceConnection->getTableName($name);
    }
    public function getMultifeeValue(){
        return $this->tblDataHelper->getMultifeeValue();
    }
 
    public function getSpeditionWeightMin(){
        return $this->tblDataHelper->getSpeditionWeightMin();
    }
    public function getSpeditionWeightMax(){
        return $this->tblDataHelper->getSpeditionWeightMax();
    }

    public function getDeShippingfreeCountries(){
        return $this->tblDataHelper->getDeShippingfreeCountries();
    }

    public function getDeShippingfreeCountriesValue(){
        return $this->tblDataHelper->getDeShippingfreeCountriesValue();
    }
	
    public function getDeShippingfreeValue(){
        return $this->tblDataHelper->getDeShippingfreeValue();
    }

    public function getAdditionalInfo(){
        return $this->tblDataHelper->getAdditionalInfo();
    }
}