<?php
namespace Xtwo\Shippingtablerate\Block\Adminhtml\Form\Field;

use Magento\Config\Block\System\Config\Form\Field\FieldArray\AbstractFieldArray;
use Magento\Framework\DataObject;
use Magento\Framework\Exception\LocalizedException;

/**
 * Class Ranges
 */
class Countrypriceinfo extends AbstractFieldArray
{

    private $descriptionRenderer;

    /**
     * Prepare rendering the new field by adding all the needed columns
     */
    protected function _prepareToRender()
    {
		$renderer_country = $this->getLayout()->createBlock(
			'Xtwo\Shippingtablerate\Block\Adminhtml\Form\Field\Countries', '', array());
		$this->addColumn('country_id', array(
			'label' => __('Land'),
			'style' => 'width:100px;',
			 'renderer' => $this->getCountryRenderer()
			
		));

		$renderer = $this->getLayout()->createBlock(
			'Xtwo\Shippingtablerate\Block\Adminhtml\Form\Field\Textarea', '', array());
		
		$this->addColumn('description', array(
			'label' => __('Beschreibung'),
		));
        $this->_addAfter = false;
        $this->_addButtonLabel = __('Land hinzufügen');
    }

    /**
     * Prepare existing row data object
     *
     * @param DataObject $row
     * @throws LocalizedException
     */
    protected function _prepareArrayRow(DataObject $row): void
    {
        $options = [];

        $country = $row->getCountry_id();
        if ($country !== null) {
            $options['option_' . $this->getCountryRenderer()->calcOptionHash($country)] = 'selected="selected"';
        }
        $row->setData('option_extra_attrs', $options);
    }

    /**
     * @throws LocalizedException
     */
    private function getDescriptionRenderer()
    {
        if (!$this->descriptionRenderer) {
            $this->descriptionRenderer = $this->getLayout()->createBlock(
                \Xtwo\Shippingtablerate\Block\Adminhtml\Form\Field\Textarea::class,
                '',
                ['data' => ['is_render_to_js_template' => true]]
            );
        }
        return $this->descriptionRenderer;
    }
	private function getCountryRenderer()
    {
            $this->countryRenderer = $this->getLayout()->createBlock(
                \Xtwo\Shippingtablerate\Block\Adminhtml\Form\Field\Countries::class,
                '',
                ['data' => ['is_render_to_js_template' => true]]
            );
        return $this->countryRenderer;
    }
}
