<?php

namespace Xtwo\Shippingtablerate\Block\Adminhtml\Form\Field;
use Magento\Framework\View\Element\Context;
use Magento\Framework\View\Element\Html\Select;
use Xtwo\Shippingtablerate\Helper\Country;
class Countries extends Select {
	private $_countries;

	/**
	 * Retrieve complete country list from magento
	 */
	protected $_country;

	 /**
     * @var Country
     */
    private $countryHelper;

    /**
     * Constructor
     *
     * @param Context $context
     * @param Country $countryHelper
     * @param array $data
     */
    public function __construct(Context $context, Country $countryHelper, array $data = [])
    {
        parent::__construct($context, $data);
        $this->countryHelper = $countryHelper;
    }

    /**
     * @inheritDoc
     */
    protected function _toHtml(): string
    {
        if (!$this->getOptions()) {
            $this->setOptions($this->countryHelper->getCountries());
        }
        return parent::_toHtml();
    }

	/**
	 * Set the name of the country
	 */
	public function setInputName($value)
	{
		return $this->setName($value);
	}
    /**
     * Set "id" for <select> element
     *
     * @param $value
     * @return $this
     */
    public function setInputId($value)
    {
        return $this->setId($value);
    }
}