<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Shippingtablerate\Block\Admin\System\Config\Form\Field;

use Magento\Framework\View\Helper\SecureHtmlRenderer;


use Magento\Backend\Block\Template\Context;
use Magento\Config\Block\System\Config\Form\Field\FieldArray\AbstractFieldArray;

class Countrypriceinfo extends AbstractFieldArray
{

	const PRICE_TABLE_PREFIX = "carriers_shippingtablerate_additional_info";

	/** @var \Magento\CatalogInventory\Block\Adminhtml\Form\Field\Customergroup */
	protected $_priceRenderer;

	/**
	 * Retrieve group column renderer
	 *
	 * @return \Magento\CatalogInventory\Block\Adminhtml\Form\Field\Customergroup
	 */
	protected function _getPriceRenderer()
	{

		$countryCode = str_replace(
			self::PRICE_TABLE_PREFIX, '', $this->getElement()->getId()
		);

		if (!$this->_priceRenderer)
		{
			$this->_priceRenderer = $this->getLayout()->createBlock(
				'Xtwo\Shippingtablerate\Block\Admin\Form\Field\Countries', '', array('country_code' => $countryCode)
			);
		}

		return $this->_priceRenderer;
	}

	/**
	 * Default class constructor
	 */
	public function __construct(Context $context,

	array $data = []
	)
	{
		
	

		parent::__construct($context, $data);
      
		$this->setTemplate('Magento_Config::system/config/form/field/array.phtml');
		$this->_addButtonLabel = __('Land hinzufügen');
	}

	


	protected function _getElementHtml(\Magento\Framework\Data\Form\Element\AbstractElement $element)
	{

		$renderer_country = $this->getLayout()->createBlock(
			'Xtwo\Shippingtablerate\Block\Admin\Form\Field\Countries', '', array());

		$this->addColumn('country_id', array(
			'label' => __('Land'),
			'style' => 'width:100px;',
			 'renderer' => $renderer_country
			
		));

		$renderer = $this->getLayout()->createBlock(
			'Xtwo\Shippingtablerate\Block\Admin\Form\Field\Textarea', '', array());

		$this->addColumn('description', array(
			'label' => __('Beschreibung'),
			'style' => 'height:100px; vertical-align:top;',
			'renderer' => $renderer
		));

		return parent::_getElementHtml($element);
	}

	public function getConfigElementName() {
		return 'additional_info';
	}
}