<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Shippingtablerate\Block\Admin\Form\Field;



class Textarea extends \Magento\Framework\View\Element\Text {
    public function __construct(
        \Magento\Framework\View\Element\Context $context,
        array $data = []
    ) {
        parent::__construct(
            $context,
            $data
        );
    }


	/**
	 * Set the name of the country
	 */
	public function setInputName($value)
	{
		return $this->setName($value);
	}

	/**
	 * Render block HTML
	 *
	 * @return string
	 */
	public function _toHtml()
	{
		$column = $this->getColumn();
		$element = '<textarea name="' . $this->getName() .
			($column['size'] ? 'size="' . $column['size'] . '"' : '') . ' class="' .
			(isset($column['class']) ? $column['class'] : 'input-text') . '"'.
			(isset($column['style']) ? ' style="'.$column['style'] . '"' : '') . '>#{' . $this->getColumnName() . '}</textarea>';
		return $element;
	}

}