<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Shippingtablerate\Block\Admin\Form\Field;
use Magento\Framework\View\Element\Context;
use Magento\Framework\View\Element\Html\Select;
use Xtwo\Shippingtablerate\Helper\Country;

class Countries extends Select {


	private $_countries;

	/**
	 * Retrieve complete country list from magento
	 */

	protected $_country;




	 /**
     * @var Country
     */
    private $countryHelper;

    /**
     * Constructor
     *
     * @param Context $context
     * @param Country $countryHelper
     * @param array $data
     */
    public function __construct(Context $context, Country $countryHelper, array $data = [])
    {
        parent::__construct($context, $data);
        $this->countryHelper = $countryHelper;
    }

    /**
     * @inheritDoc
     */
    protected function _toHtml(): string
    {
        if (!$this->getOptions()) {
            $this->setOptions($this->countryHelper->getCountries());
        }
        return parent::_toHtml();
    }



	

	/**
	 * Set the name of the country
	 */
	public function setInputName($value)
	{
		return $this->setName($value);
	}

	/**
	 * Render block HTML
	 *
	 * @return string
	 */
	

}