<?php

namespace Xtwo\Setup\Setup;

use Magento\Framework\Setup\InstallDataInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;

/**
 * Class InstallData
 */
class RecurringData implements InstallDataInterface
{
    const STORE = [
        "0,admin,0,0,Admin,0,1",
        "1,xtwostore_de,1,1,xtwostore.de,0,1",
        "2,xtwostore_com,2,2,xtwostore.com,0,1",
        "3,xtwostore_fr,3,3,xtwostore.fr,0,1",
        "4,xtwostore_cn,4,4,xtwostore.cn,0,1",
        "5,xtwostore_at,5,5,xtwostore.at,0,1",
        "6,xtwostore_couk,6,6,xtwostore.co.uk,0,1",
        "7,xtwostore_be,7,7,xtwostore.be,0,1",
        "8,xtwostore_ch,8,8,xtwostore.ch,0,1",
        "9,xtwostore_hk,9,9,xtwostore.hk,0,1",
        "10,xtwostore_sg,10,10,xtwostore.sg,0,1",
        "11,xtwostore_ie,11,12,xtwostore.ie,0,1",
        "12,xtwostore_tw,12,13,xtwostore.tw,0,0",
        "13,xtwostore_nl,13,14,xtwostore.nl,0,1",
        "14,xtwostore_dk,14,15,xtwostore.dk,0,1",
        "15,xtwostore_se,15,16,xtwostore.se,0,1",
        "16,xtwostore_es,16,17,xtwostore.es,0,1",
        "17,xtwostore_it,17,18,xtwostore.it,0,1",
        "18,xtwostore_pt,18,19,xtwostore.pt,0,1",
        "20,xtwostore_ae,20,21,xtwostore.ae,0,1",
        "23,xtwostore_us,23,24,xtwostore.us,80,0",
        "26,xtwostore_coza,26,27,xtwostore.co.za,110,1",
        "27,xtwostore_in,27,28,xtwostore.in,120,0",
        "28,xtwostore_pl,28,29,xtwostore.pl,130,1",
        "29,xtwostore_cz,29,30,xtwostore.cz,140,1",
        "38,ytwo_xtwostore_de,38,39,ytwo.xtwostore.de,230,1",
    ];
    const WEBSITE = [
        "0,admin,Admin,0,0,0",
        "1,xtwostore_de,xtwostore.de,10,1,1",
        "2,xtwostore_com,xtwostore.com,70,2,0",
        "3,xtwostore_fr,xtwostore.fr,50,3,0",
        "4,xtwostore_cn,xtwostore.cn,500,4,0",
        "5,xtwostore_at,xtwostore.at,20,5,0",
        "6,xtwostore_couk,xtwostore.co.uk,70,6,0",
        "7,xtwostore_be,xtwostore.be,60,7,0",
        "8,xtwostore_ch,xtwostore.ch,30,8,0",
        "9,xtwostore_hk,xtwostore.hk,80,9,0",
        "10,xtwostore_sg,xtwostore.sg,80,10,0",
        "11,xtwostore_ie,xtwostore.ie,80,12,0",
        "12,xtwostore_tw,xtwostore.tw,80,13,0",
        "13,xtwostore_nl,xtwostore.nl,80,14,0",
        "14,xtwostore_dk,xtwostore.dk,80,15,0",
        "15,xtwostore_se,xtwostore.se,80,16,0",
        "16,xtwostore_es,xtwostore.es,100,17,0",
        "17,xtwostore_it,xtwostore.it,100,18,0",
        "18,xtwostore_pt,xtwostore.pt,80,19,0",
        "20,xtwostore_ae,xtwostore.ae,100,21,0",
        "23,xtwostore_us,xtwostore.us,80,24,0",
        "26,xtwostore_coza,xtwostore.co.za,110,27,0",
        "27,xtwostore_in,xtwostore.in,120,28,0",
        "28,xtwostore_pl,xtwostore.pl,130,29,0",
        "29,xtwostore_cz,xtwostore.cz,140,30,0",
        "38,ytwo_xtwostore_de,ytwo.xtwostore.de,40,39,0",
    ];
    const GROUP = [
        "0,0,Default,0,0",
        "1,1,xtwostore.de,2,1",
        "2,2,xtwostore.com,2,2",
        "3,3,xtwostore.fr,2,3",
        "4,4,xtwostore.cn,2,4",
        "5,5,xtwostore.at,2,5",
        "6,6,xtwostore.co.uk,2,6",
        "7,7,xtwostore.be,2,7",
        "8,8,xtwostore.ch,2,8",
        "9,9,xtwostore.hk,2,9",
        "10,10,xtwostore.sg,2,10",
        "12,11,xtwostore.ie,2,11",
        "13,12,xtwostore.tw,2,12",
        "14,13,xtwostore.nl,2,13",
        "15,14,xtwostore.dk,2,14",
        "16,15,xtwostore.se,2,15",
        "17,16,xtwostore.es,2,16",
        "18,17,xtwostore.it,2,17",
        "19,18,xtwostore.pt,2,18",
        "21,20,xtwostore.ae,2,20",
        "24,23,xtwostore.us,2,23",
        "27,26,xtwostore.co.za,2,26",
        "28,27,xtwostore.in,2,27",
        "29,28,xtwostore.pl,2,28",
        "30,29,xtwostore.cz,2,29",
        "39,38,ytwo.xtwostore.de,2,38",
    ];

    private array $entities = [];

    /**
     * @param \Magento\Framework\Setup\ModuleDataSetupInterface $setup
     * @param \Magento\Framework\Setup\ModuleContextInterface $context
     */
    public function install(ModuleDataSetupInterface $setup, ModuleContextInterface $context)
    {
//        $ciDeployTarget = @getenv('DEPLOY_TARGET_ENV');
//        if ($ciDeployTarget !== false) {
//            $setup->startSetup();
//            $this->installWebsites($setup, $context);
//            $this->installGroups($setup, $context);
//            $this->installStores($setup, $context);
//            $setup->endSetup();
//        }
    }

    /**
     * @param \Magento\Framework\Setup\ModuleDataSetupInterface $setup
     * @param \Magento\Framework\Setup\ModuleContextInterface $context
     */
    private function installWebsites(ModuleDataSetupInterface $setup, ModuleContextInterface $context)
    {
        foreach (self::WEBSITE as $row) {
            list($id, $code, $name, $sort, $defaultGrpId, $isDefault) = explode(',', $row);
            $table = $setup->getTable('store_website');
            $sql = "REPLACE INTO $table (`website_id`,`code`,`name`,`sort_order`,`default_group_id`,`is_default`) " .
                "VALUE ('$id','$code','$name','$sort','$defaultGrpId','$isDefault')";
            $setup->getConnection()->query($sql);
        }
    }

    /**
     * @param \Magento\Framework\Setup\ModuleDataSetupInterface $setup
     * @param \Magento\Framework\Setup\ModuleContextInterface $context
     */
    private function installGroups(ModuleDataSetupInterface $setup, ModuleContextInterface $context)
    {
        foreach (self::GROUP as $row) {
            list($id, $websiteId, $name, $rootCatId, $defaultStoreId) = explode(',', $row);
            $rootCatId = 1; // TODO
            $table = $setup->getTable('store_group');
            $sql = "REPLACE INTO $table (`group_id`,`website_id`,`name`,`root_category_id`,`default_store_id`,`code`) " .
                "VALUE ('$id','$websiteId','$name','$rootCatId','$defaultStoreId', NULL)";
            $setup->getConnection()->query($sql);
        }
    }

    /**
     * @param \Magento\Framework\Setup\ModuleDataSetupInterface $setup
     * @param \Magento\Framework\Setup\ModuleContextInterface $context
     */
    private function installStores(ModuleDataSetupInterface $setup, ModuleContextInterface $context)
    {
        foreach (self::STORE as $row) {
            list($id, $code, $websiteId, $groupId, $name, $sort, $isActive) = explode(',', $row);
            $table = $setup->getTable('store');
            $sql = "REPLACE INTO $table (`store_id`,`code`,`website_id`,`group_id`,`name`,`sort_order`,`is_active`) " .
                "VALUE ('$id','$code','$websiteId','$groupId','$name','$sort','$isActive')";
            $setup->getConnection()->query($sql);
        }
    }
}
