<?php
namespace Xtwo\SalesOrderView\Helper;

use DateInterval;

class Data extends \Magento\Framework\App\Helper\AbstractHelper {

    public $productFactory;

    public $product;

    public $scopeConfig;

    private $mapping = null;

    const XML_PATH_DELIVERY_MAPPING = 'delivery_time/delivery_time/mapping_delivery';

    public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        \Magento\Catalog\Model\ProductFactory $productFactory,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Catalog\Model\Product $product
    ) {
        $this->productFactory = $productFactory;
        $this->product = $product;
        $this->scopeConfig = $scopeConfig;
        parent::__construct($context);
    }

    public function getProductDataById($sku) {
        // return $this->product->load($productId);
        return $this->product->loadByAttribute('sku', $sku);
    }

    /* Get Label by option id */
    public function getOptionLabelByValue($attributeCode,$optionId)
    {
        $product = $this->productFactory->create();
        $isAttributeExist = $product->getResource()->getAttribute($attributeCode); 
        $optionText = '';
        if ($isAttributeExist && $isAttributeExist->usesSource()) {
            $optionText = $isAttributeExist->getSource()->getOptionText($optionId);
        }
        return $optionText;
    }

   /* Get Option id by Option Label */
    public function getOptionIdByLabel($attributeCode,$optionLabel)
    {
        $product = $this->productFactory->create();
        $isAttributeExist = $product->getResource()->getAttribute($attributeCode);
        $optionId = '';
        if ($isAttributeExist && $isAttributeExist->usesSource()) {
            $optionId = $isAttributeExist->getSource()->getOptionId($optionLabel);
        }
        return $optionId;
    }

    public function getAttributeDeliveryTimeValue($attributeId) {

        $mapping = $this->getMappingAttribute();

        if (isset($mapping[$attributeId])) {
			return $mapping[$attributeId];
		}
	
		return 0;
    }

    private function getMappingAttribute() {
		if ($this->mapping == null) {


            $mapping_str = $this->scopeConfig->getValue(self::XML_PATH_DELIVERY_MAPPING, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, );
			
			$mapping_arr = explode(",", $mapping_str);
			
			$this->mapping = array();
			for ($i = 0; $i < count($mapping_arr); $i++) {
				$tmp = explode(":", $mapping_arr[$i]);
				$this->mapping[$tmp[0]] = $tmp[1];
			}
		}
		
		return $this->mapping;
	}

    public function getProcessingDate($order) {

        $payment = $order->getPayment();
        $method = $payment->getMethodInstance();
        $methodCode = $method->getCode();
        
        if($methodCode != 'paypal_express') {
            $histories = $order->getStatusHistories();
            /** @var OrderStatusHistoryInterface $caseCreationComment */
            // $latestHistoryComment = array_pop($histories);
            $latestHistoryComment = array_pop($histories);
            if(!empty($latestHistoryComment)){
                $status = $latestHistoryComment->getStatus();
                if ($status == 'processing') {
                    return $latestHistoryComment->getCreatedAt();
                }
            }
            return null;
        } else {
            return $order->getCreatedAt();
        }
	}


    function getDeliveryDate($date, $plus) {
		$date->add(new DateInterval('P'.$plus.'W'));
		if ($date->format('w') == 6 || $date->format('w') == 0 || $date->format('w') == 5) {
			$date->add(new DateInterval('P1W'));
		}
		// CHRISTAMS check
		if ($date->format('W') <= 3 || $date->format('W') >= 52) {
			$date->add(new DateInterval('P1W'));
		}
		return $date;
	}

}