<?php 
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_SalesMailing
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 * @author      Hemendra Ajmera
 */

 namespace Xtwo\SalesMailing\Setup;

use Magento\Framework\Setup\UpgradeSchemaInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\ModuleContextInterface;

class UpgradeSchema implements UpgradeSchemaInterface
{
    /**
     * @var \Magento\Framework\DB\Ddl\TriggerFactory
     */
    protected $triggerFactory;
    /**
     * Constructor function
     */
    public function __construct(
        \Magento\Framework\DB\Ddl\TriggerFactory $triggerFactory
    )
    {
        $this->triggerFactory = $triggerFactory;
    }
    public function upgrade( SchemaSetupInterface $setup, ModuleContextInterface $context ) {
		$installer = $setup;

		$installer->startSetup();
        $logFile = BP.'/var/log/xtwo-infomailing.log';
        file_put_contents($logFile, '--- setup start ---'.PHP_EOL, FILE_APPEND);

		if(version_compare($context->getVersion(), '1.2.0', '<')) {
            $installer->run("
            DROP TRIGGER IF EXISTS xtwo_infomailing_status_change;");

            /** @var \Magento\Framework\DB\Ddl\Trigger $trigger */

            foreach (array('update') as $event) {
                $itemKey = 'NEW';
                $trigger = $this->triggerFactory->create()
                ->setName('xtwo_infomailing_status_change')
                ->setTime(\Magento\Framework\DB\Ddl\Trigger::TIME_AFTER)
                ->setEvent(strtoupper($event))
                ->setTable($setup->getTable('sales_order'))
                ->addStatement("UPDATE IGNORE `{$setup->getTable('xtwo_order_infomailing')}` SET `status` = {$itemKey}.`status`, `status_change_at` = NOW(), `status_change_processed` = NULL, `blocked_until` = NULL WHERE `entity_id` = {$itemKey}.`entity_id` AND `status` != {$itemKey}.`status`;");
                //$setup->getConnection()->dropTrigger($trigger->getName()); //Throwing error in production master DB
                $setup->getConnection()->createTrigger($trigger);
            }

            foreach (array('insert') as $event) {
                $itemKey = 'NEW';
                $trigger = $this->triggerFactory->create()
                ->setName('xtwo_infomailing_status_new')
                ->setTime(\Magento\Framework\DB\Ddl\Trigger::TIME_AFTER)
                ->setEvent(strtoupper($event))
                ->setTable($setup->getTable('sales_order'))
                ->addStatement("INSERT IGNORE INTO `{$setup->getTable('xtwo_order_infomailing')}` (entity_id, status, status_change_at) VALUES ({$itemKey}.`entity_id`, '{$itemKey}.`status`', NOW());");
                // $setup->getConnection()->dropTrigger($trigger->getName()); //Throwing error in production master DB
                $setup->getConnection()->createTrigger($trigger);
            }
		}

        if(version_compare($context->getVersion(), '1.4.0', '<')) {
            file_put_contents($logFile, '--- start Upgrade ---'.PHP_EOL, FILE_APPEND);


            $installer->getConnection()->changeColumn(
                $installer->getTable('xtwo_order_infomailing'),
                'status_change_processed',
                'status_change_processed',
                [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
                    'nullable' => true,
                    'comment' => 'Status change processed'
                ]
            );

            $installer->getConnection()->changeColumn(
                $installer->getTable('xtwo_order_infomailing'),
                'blocked_until',
                'blocked_until',
                [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
                    'nullable' => true,
                    'comment' => 'Blocked until'
                ]
            );
        }

		$installer->endSetup();
	}
}