<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_SalesMailing
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */
namespace Xtwo\SalesMailing\Setup;

class InstallSchema implements \Magento\Framework\Setup\InstallSchemaInterface
{
    public function install(\Magento\Framework\Setup\SchemaSetupInterface $setup, \Magento\Framework\Setup\ModuleContextInterface $context)
	{
        $installer = $setup;
		$installer->startSetup();
        if (!$installer->tableExists('xtwo_order_infomailing')) {
			$table = $installer->getConnection()->newTable(
				$installer->getTable('xtwo_order_infomailing')
			)
				->addColumn(
					'entity_id',
					\Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
					null,
					[
						'identity' => true,
						'nullable' => false,
						'primary'  => true,
						'unsigned' => true,
					],
					'Entity ID'
				)
				->addColumn(
					'status',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					255,
					['nullable => false'],
					'status'
				)
				->addColumn(
					'status_change_at',
					\Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
					null,
					[
                        'nullable' => false, 
                        'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT
					],
					'Status change At'
				)->addColumn(
					'status_change_processed',
					\Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
					null,
					[
                        'nullable' => false, 
                        'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT_UPDATE
					],
					'Status change processed'
                )->addColumn(
					'blocked_until',
					\Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
					null,
					[
                        'nullable' => false, 
                        'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT_UPDATE
					],
					'Blocked until')
                ->addColumn(
                        'process_log',
                        \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        '64k',
                        [
                            'nullable' => true, 
                        ],
                        'process log'
                    )
					->addColumn(
                        'last_email_sent_at',
                        \Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
                        null,
                        [
							'nullable' => true,
                        ],
                        'process log'
                    )
					
				->setComment('Xtwo sale_infomailing Table');
			$installer->getConnection()->createTable($table);
		}
        $installer->endSetup();
    }
}