<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_SalesMailing
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */
namespace Xtwo\SalesMailing\Model\Service;

class Hasher
{
    /**
     * @var \Magento\Framework\Encryption\EncryptorInterface
     */
    protected $encryptorInterface;

    public function __construct(
        \Magento\Framework\Encryption\EncryptorInterface $encryptorInterface
    ) {
        $this->encryptorInterface = $encryptorInterface;
    }

    /**
     * Hash filename
     *
     * @param string $filename
     *
     * @return string
     */
    public function hash($filename)
    {
        //return rawurlencode($this->getEncryptor()->encrypt($filename));
        return rawurlencode($this->encryptorInterface->encrypt($filename));
        
    }

    /**
     * Check if hash is valid
     *
     * @param string $hash
     * @param string $filename
     *
     * @return bool
     */
    public function isHashValid($hash, $filename)
    {
        if (strpos($hash, '%') !== false) $hash = rawurldecode($hash);
        //$encoded = $this->getEncryptor()->encrypt($filename);
        $encoded = $this->encryptorInterface->encrypt($filename);
        $isEqual = hash_equals($encoded, $hash);
        //if (!$isEqual) Js_Log::log(sprintf('Hashes not equal! just=%s, existing=%s', $encoded, $hash),
       //         $this, \Zend_Log::ALERT);
        
        return $isEqual;
    }

    /**
     * Get Magento encryptor
     *
     * @return \Magento\Framework\Encryption\EncryptorInterface
     * not used we directly changed whenever it used
     */
    private function getEncryptor()
    {
        return Mage::getSingleton('core/encryption');
    }
} 