<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_SalesMailing
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */
namespace Xtwo\SalesMailing\Model\Service;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Aws\S3\S3Client;
class FileResolver 
{
    const WRITE_PATH_PATH = '_pdf';

    const WRITE_INVOICES_PATH_PATH = '_invoices';

    const WRITE_SHIPPING_PATH_PATH = '_shippings';

    const WRITE_ORDERCONFIRMATION_PATH_PATH = '_orderconfirmation';

    const WRITE_CREDITMEMO_PATH_PATH = '_creditmemo';


    const READ_INVOICE_PART_NAME = '_invoice';

    const READ_SHIPMENT_PART_NAME = '_delivery-note';

    const READ_ORDER_CONFIRMATION_PART_NAME = '_order_confirmation';

    const READ_CREDIT_MEMO_PART_NAME = '_credit_memo';

    /**
     * @var \Magento\Sales\Model\OrderFactory
     */
    protected $salesOrderFactory;

    /**
     * @var \Magento\Framework\DataObjectFactory
     */
    /**
     * @var ScopeConfigInterface
     */
    protected $scopeConfig;
    protected $dataObjectFactory;
    protected $_storeManager;



    public function __construct(
        \Magento\Sales\Model\OrderFactory $salesOrderFactory,
        \Magento\Framework\DataObjectFactory $dataObjectFactory,
        ScopeConfigInterface $scopeConfig,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Framework\Filesystem\DirectoryList $dir,
    ) {
        $this->dataObjectFactory = $dataObjectFactory;
        $this->salesOrderFactory = $salesOrderFactory;
        $this->scopeConfig = $scopeConfig;
        $this->_storeManager = $storeManager;
        $this->dir = $dir;
    }

    /**
     * Resolve data
     *
     * @param $fileName
     *
     * @return \Magento\Framework\DataObject
     */
    public function resolve($fileName)
    {
        $resultObject = $this->dataObjectFactory->create();

        try {
            if (($pos = strpos($fileName, self::READ_INVOICE_PART_NAME)) !== false) {

                $resultObject->setData(array(
                    'type'         => 'invoice',
                    'file_name'    => $fileName,
                    'order'        => null));

                //if filename is invoice
                $incrementId = substr($fileName, 0, strpos($fileName, '_'));   // str_replace(self::READ_INVOICE_PART_NAME, '', $fileName);

                // position must be > 0 as it starts with order ID and must be a numeric order ID
                if ($pos > 0 && is_numeric($incrementId)) {
                   
                    $order = $this->salesOrderFactory->create()->loadByIncrementId($incrementId);
                  
                    if ($order && $order->getId()) {
                        $paths = $this->getInvoiceDocumentPath($order, $fileName);
                        
                        $resultObject->setData(array(
                            'increment_id' => $incrementId,
                            'type'         => 'invoice',
                            'file_name'    => $fileName,
                            'path'         => reset($paths),
                            'order'        => $order));
                           
                    }
                   
                }

            } elseif (($pos = strpos($fileName, self::READ_SHIPMENT_PART_NAME)) !== false) {

                $resultObject->setData(array(
                    'type'         => 'invoice',
                    'file_name'    => $fileName,
                    'order'        => null));

                //if filename is shipment
                $incrementId = substr($fileName, 0, strpos($fileName, '_')); //str_replace(self::READ_SHIPMENT_PART_NAME, '', $fileName);

                // position must be > 0 as it starts with order ID and must be a numeric order ID
                if ($pos > 0 && is_numeric($incrementId)) {
                    $order = $this->salesOrderFactory->create()->loadByIncrementId($incrementId);
                    
                    if ($order && $order->getId()) {
                        $paths = $this->getShippingDocumentPath($order, $fileName);
                       
                        $resultObject->setData(array(
                                'increment_id' => $incrementId,
                                'type'         => 'shipment',
                                'path'         => reset($paths),
                                'file_name'    => $fileName,
                                'order'        => $order));
                    }
                }

            } elseif (($pos = strpos($fileName, self::READ_ORDER_CONFIRMATION_PART_NAME)) !== false) {

                $resultObject->setData(array(
                    'type'         => 'orderconfirmation',
                    'file_name'    => $fileName,
                    'order'        => null));

                //if filename is shipment
                $incrementId = substr($fileName, 0, strpos($fileName, '_')); //str_replace(self::READ_SHIPMENT_PART_NAME, '', $fileName);

                // position must be > 0 as it starts with order ID and must be a numeric order ID
                if ($pos > 0 && is_numeric($incrementId)) {
                    $order = $this->salesOrderFactory->create()->loadByIncrementId($incrementId);
                    if ($order && $order->getId()) {
                        $paths = $this->getOrderConfirmationDocumentPath($order, $fileName);
                        $resultObject->setData(array(
                            'increment_id' => $incrementId,
                            'type'         => 'orderconfirmation',
                            'path'         => reset($paths),
                            'file_name'    => $fileName,
                            'order'        => $order));
                    }
                }

            } elseif (($pos = strpos($fileName, self::READ_CREDIT_MEMO_PART_NAME)) !== false) {

                $resultObject->setData(array(
                    'type'         => 'creditmemo',
                    'file_name'    => $fileName,
                    'order'        => null));

                //if filename is shipment
                $incrementId = substr($fileName, 0, strpos($fileName, '_')); //str_replace(self::READ_SHIPMENT_PART_NAME, '', $fileName);

                // position must be > 0 as it starts with order ID and must be a numeric order ID
                if ($pos > 0 && is_numeric($incrementId)) {
                    $order = $this->salesOrderFactory->create()->loadByIncrementId($incrementId);
                    if ($order && $order->getId()) {
                        $paths = $this->getCreditMemoDocumentPath($order, $fileName);
                        $resultObject->setData(array(
                            'increment_id' => $incrementId,
                            'type'         => 'creditmemo',
                            'path'         => reset($paths),
                            'file_name'    => $fileName,
                            'order'        => $order));
                    }
                }
            }

        } catch (\Exception $e) {
            echo $$e->getMessage();
            return $resultObject;
        }
        return $resultObject;
    }
    /**
     * Get document path for invoice document(s). If optional $fileName is empty an array of all existing documents
     * returns. If $fileName is not empty, the array returns only this one file.
     *
     * @param \Magento\Sales\Model\Order $order
     * @param string $fileName Specific file name if required!
     *
     * @return array
     */
    public function getInvoiceDocumentPath(\Magento\Sales\Model\Order $order, $fileName=null)
    {
        $shippingAddress = $order->getShippingAddress();
        $lastName = $shippingAddress ? $shippingAddress->getLastname() : null;
        if (!$lastName) {
            $billingAddress = $order->getBillingAddress();
            $lastName = $billingAddress ? $billingAddress->getLastname() : 'Xx';
        }
        if ($fileName && $fileName instanceof \Magento\Framework\DataObject) {
            $fileName = $fileName->getData('file_name');
        }
        return $this->getNewFilePath($order,'invoice', $lastName, $fileName);
    }

    /**
     * Get document path for shipping document(s). If optional $fileName is empty an array of all existing documents
     * returns. If $fileName is not empty, the array returns only this one file.
     *
     * @param \Magento\Sales\Model\Order $order
     * @param string $fileName
     *
     * @return array
     */
    public function getShippingDocumentPath(\Magento\Sales\Model\Order $order, $fileName=null)
    {
        $shippingAddress = $order->getShippingAddress();
        $lastName = $shippingAddress ? $shippingAddress->getLastname() : null;
        if (!$lastName) {
            $billingAddress = $order->getBillingAddress();
            $lastName = $billingAddress ? $billingAddress->getLastname() : 'Xx';
        }
        if ($fileName && $fileName instanceof \Magento\Framework\DataObject) {
            $fileName = $fileName->getData('file_name');
        }
        return $this->getNewFilePath($order,'shipment', $lastName, $fileName);
    }

    /**
     * Get document path for shipping document(s). If optional $fileName is empty an array of all existing documents
     * returns. If $fileName is not empty, the array returns only this one file.
     *
     * @param \Magento\Sales\Model\Order $order
     * @param string $fileName
     *
     * @return array
     */
    public function getOrderConfirmationDocumentPath(\Magento\Sales\Model\Order $order, $fileName=null)
    {
        $lastName = $order->getShippingAddress()->getLastname();
        if ($fileName && $fileName instanceof \Magento\Framework\DataObject) {
            $fileName = $fileName->getData('file_name');
        }
        return $this->getNewFilePath($order,'orderconfirmation', $lastName, $fileName);
    }

    /**
     * Get document path for shipping document(s). If optional $fileName is empty an array of all existing documents
     * returns. If $fileName is not empty, the array returns only this one file.
     *
     * @param \Magento\Sales\Model\Order $order
     * @param string $fileName
     *
     * @return array
     */
    public function getCreditMemoDocumentPath(\Magento\Sales\Model\Order $order, $fileName=null)
    {
        $lastName = $order->getShippingAddress()->getLastname();
        if ($fileName && $fileName instanceof \Magento\Framework\DataObject) {
            $fileName = $fileName->getData('file_name');
        }
        return $this->getNewFilePath($order,'creditmemo', $lastName, $fileName);
    }

    /**
     * Get file path(s). The order of the files (if $fileName is empty) is creation date desc.
     *
     * @param \Magento\Sales\Model\Order $order
     * @param string $type
     * @param string $lastName
     * @param string|null $fileName
     *
     * @return array
     */
    private function getNewFilePath($order, $type, $lastName, $fileName=null)
    {
        
        //$this->_storeManager->getStore()->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA) 
        //$directoryPath = Mage::getConfig()->getOptions()->getMediaDir() . DS . self::WRITE_PATH_PATH;
        $directoryPath= $this->_storeManager->getStore()->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA).self::WRITE_PATH_PATH;
        $directoryPath= $this->dir->getPath('media').DIRECTORY_SEPARATOR.self::WRITE_PATH_PATH;

        $documentCdnEnabled = $this->scopeConfig->getValue( 'aws_s3_connection/configuration/document_cdn', 
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
        $documentCdnAccessKey = $this->scopeConfig->getValue( 'aws_s3_connection/configuration/cdn_access_key', 
        \Magento\Store\Model\ScopeInterface::SCOPE_STORE); 
        $documentCdnsecretKey = $this->scopeConfig->getValue( 'aws_s3_connection/configuration/cdn_secret_key', 
        \Magento\Store\Model\ScopeInterface::SCOPE_STORE); 
        $documentCdnRegion = $this->scopeConfig->getValue( 'aws_s3_connection/configuration/cdn_region', 
        \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
        $documentCdnEndPoint = $this->scopeConfig->getValue( 'aws_s3_connection/configuration/cdn_end_point', 
        \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
        $bucketName = $this->scopeConfig->getValue( 'aws_s3_connection/configuration/cdn_bucket_name', 
        \Magento\Store\Model\ScopeInterface::SCOPE_STORE);

        if($documentCdnEnabled){
            //S3
            $customEndpoint = $documentCdnEndPoint; // CDN custom endpoint URL
            $s3MediaFolder ='media';
            $s3PdfFolder ='_pdf';
            $version ='latest';
            $region = $documentCdnRegion;
            $s3Client = new S3Client([
                'version'     => $version,
                'region'      => $region, 
                //'endpoint'    => $customEndpoint,
                //'use_path_style_endpoint' => true, // Set to true if your custom endpoint uses path-style URLs
                'credentials' => [
                    'key'    => $documentCdnAccessKey,
                    'secret' => $documentCdnsecretKey,
                ],
                // 'scheme'  => 'http'
            ]);
            //S3
        }

        $typePart = '-';
        if ($type == 'invoice') {
            $typePart = self::WRITE_INVOICES_PATH_PATH;
            $fileMidFix = self::READ_INVOICE_PART_NAME;
        } elseif ($type == 'shipment') {
            $typePart = self::WRITE_SHIPPING_PATH_PATH;
            $fileMidFix = self::READ_SHIPMENT_PART_NAME;
        } elseif ($type == 'orderconfirmation') {
            $typePart = self::WRITE_ORDERCONFIRMATION_PATH_PATH;
            $fileMidFix = self::READ_ORDER_CONFIRMATION_PART_NAME;
        } elseif ($type == 'creditmemo') {
            $typePart = self::WRITE_CREDITMEMO_PATH_PATH;
            $fileMidFix = self::READ_CREDIT_MEMO_PART_NAME;
        }
        // getting order documents list 
        $documentList = $order->getDocumentList();
        
        $documentListArray = [];
        if(!empty($documentList)){
            $documentListArray = explode(',',$documentList);
        }
        
        $namePart = !empty($lastName) ? substr($lastName, 0, 1) : 'x';
        $namePart = strtolower($namePart);
        $path = $directoryPath . '/' . $typePart . '/' . $namePart;
        $path =  $typePart ;
        if($documentCdnEnabled){
            //$s3FullPath =  $customEndpoint.'/'.$s3MediaFolder.'/'.$s3PdfFolder.'/'.$typePart . '/';
            $s3FullPath =  $customEndpoint.'/'.$s3PdfFolder.'/'.$typePart . '/';
        }
//echo $s3FullPath;
        if (!empty($fileName)) {
            $path .= '/' . $fileName;
           
            if($documentCdnEnabled){
                //echo $s3MediaFolder.'/'.$typePart . '/'.$fileName;
                try {
                    $s3FileExist = $s3Client->doesObjectExist($bucketName, $s3MediaFolder.'/'.$typePart . '/'.$fileName);
					
                    if($s3FileExist){
                        $s3FileExistInImport = $s3Client->doesObjectExistV2($bucketName, "_".'pdf'.'/'.'__nav_pdf_import'.'/'.$fileName);
                        if($s3FileExistInImport){
                            try {
                                $s3Client->copyObject([
                                    'Bucket' => $bucketName,
                                    'CopySource' => $bucketName.'/'."_".'pdf'.'/'.'__nav_pdf_import'.'/'.$fileName,
                                    'Key' =>  $s3MediaFolder.'/'.$typePart.'/'.$fileName,
                                ]);
                                // deleted deleteObject
                                $s3Client->deleteObject(array(
                                    'Bucket' => $bucketName,
                                    'Key'    => "_".'pdf'.'/'.'__nav_pdf_import'.'/'.$fileName
                                ));
                                }catch (\Exception $e){
                                    echo $e->getMessage();
                                }

                        }
                        
                        $file = $s3Client->getObject([
                            'Bucket' => $bucketName,
                            'Key' => $s3MediaFolder.'/'.$typePart . '/'.$fileName
                        ]);
                        $body = $file->get('Body');
                        $date = $file->get('LastModified');
                        $path= $customEndpoint.'/'.$s3MediaFolder.'/'.$typePart.'/'.$fileName;
                        if(!empty($body)){
                            return [$path];
                        }else{
                            return [$path];
                        }
                    }else{
                        
                        $s3FileExist = $s3Client->doesObjectExistV2($bucketName, "_".'pdf'.'/'.'__nav_pdf_import'.'/'.$fileName);
                        
                        //echo  $s3MediaFolder.'/'.$typePart.'/'.$fileName;
                        
                        if($s3FileExist){   
							//print_r("_".'pdf'.'/'.'__nav_pdf_import'.'/'.$fileName);
							
							 try {
                            $s3Client->copyObject([
                                'Bucket' => $bucketName,
                                'CopySource' => $bucketName.'/'."_".'pdf'.'/'.'__nav_pdf_import'.'/'.$fileName,
                                'Key' =>  $s3MediaFolder.'/'.$typePart.'/'.$fileName,
                            ]);
							}catch (\Exception $e){
								echo $e->getMessage();
							}
                            // deleted deleteObject
                            $s3Client->deleteObject(array(
                                'Bucket' => $bucketName,
                                'Key'    => "_".'pdf'.'/'.'__nav_pdf_import'.'/'.$fileName
                            ));
                            $path= $customEndpoint.'/'.$s3MediaFolder.'/'.$typePart.'/'.$fileName;
                            return [$path];
                        }
                    }
                    

                }catch (\Exception $e){
                    echo $e->getMessage();
                }
                
            }
            
        } else {
            $result = [];
            if($documentCdnEnabled){
                try {
                    $filenameExist = '';
                    $objects = $s3Client->listObjects([
                        'Bucket' => $bucketName, 
                        'Delimiter'=>'/', 
                        'Prefix' => $s3MediaFolder.'/'.$typePart . '/'.$fileName,
                    ]);
                    
                    if(!empty($objects)){
                        $files = $objects['Contents'];
                       
                        $orderIncrementId = $order->getIncrementId();
                        if(!empty($files)){
                            foreach ($files as $file) {
                               //print_r($file);
                                //if ($file[0] == '.') continue;
                
                                //$fileName = pathinfo($file)['filename'];
                                //if (strpos($fileName, $orderIncrementId) !== 0) continue;
                
                                //$cTime = filectime($file);
                                //
                                //print_r($file['LastModified']);
                                //if (strpos($file['Key'], $orderIncrementId) !== 0) continue;
                                if($file['Size']>0){
                                    //if (strpos($file['Key'], $orderIncrementId) !== 0) continue;
                                    $cTime = (date('Y-m-d H:i:s',strtotime( $file['LastModified']->format(\DateTime::ISO8601))));
                                    if (strpos($file['Key'], $orderIncrementId) > 0){
                                        $result[$cTime ? $cTime : $file['Key']] = $customEndpoint.'/'.$file['Key'];
                                    }
                                    //print_r($cTime);
                                    
    
                                }
                                //$result[$cTime ? $cTime : $fileName] = $path.'/'.$file['Key'];
                            }
                            

                        }
                       

                    }
                    
                    /*foreach($documentListArray as $k=>$dcoumentFile){

                        if (($pos = strpos($dcoumentFile, self::READ_INVOICE_PART_NAME)) !== false && $type == 'invoice') {
                            $filenameExist = $s3MediaFolder.'/'.$s3PdfFolder.'/'.self::WRITE_INVOICES_PATH_PATH. '/'.$dcoumentFile;
                        }elseif (($pos = strpos($dcoumentFile, self::READ_SHIPMENT_PART_NAME)) !== false && $type == 'shipment' ) {
                            //echo 'sdfdfdfsdfsdfd';
                            $filenameExist = $s3MediaFolder.'/'.$s3PdfFolder.'/'.self::WRITE_SHIPPING_PATH_PATH. '/'.$dcoumentFile; 
                        }elseif (($pos = strpos($dcoumentFile, self::READ_ORDER_CONFIRMATION_PART_NAME)) !== false && $type == 'orderconfirmation') {
                            $filenameExist = $s3MediaFolder.'/'.$s3PdfFolder.'/'.self::WRITE_ORDERCONFIRMATION_PATH_PATH. '/'.$dcoumentFile; 
                        } elseif (($pos = strpos($dcoumentFile, self::READ_CREDIT_MEMO_PART_NAME)) !== false && $type == 'creditmemo') {
                            $filenameExist = $s3MediaFolder.'/'.$s3PdfFolder.'/'.self::WRITE_CREDITMEMO_PATH_PATH. '/'.$dcoumentFile;
                        }

                        if(!empty($filenameExist)){
                            $file = $s3Client->getObject([
                                'Bucket' => $bucketName,
                                'Key' => $filenameExist
                            ]);
                            if(!empty($file)){
                                $body = $file->get('Body');
                                $date = $file->get('LastModified');
                                $cTime = strtotime($date);
                                $result[$cTime ? $cTime : $fileName] = $customEndpoint.'/'.$bucketName.'/'.$filenameExist;
                            }
                        }
                    }*/
                }catch (\Exception $exception) {
                    echo "Failed to download $filenameExist from $bucketName with error: " . $exception->getMessage();
                }
            }else{
                
                $orderIncrementId = $order->getIncrementId();
                
                $files = is_dir($path) ? scandir($path) : [];
                $cTime ='';
                foreach ($files as $file) {
                    if ($file[0] == '.') continue;

                    $fileName = pathinfo($file)['filename'];
                    if (strpos($fileName, $orderIncrementId) !== 0) continue;

                    $cTime = filectime($path.'/'.$file);
                    $result[$cTime ? $cTime : $fileName] = $path.'/'.$file;
                }
            }
            krsort($result);
            return $result;
        }
    }
}