<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_SalesMailing
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */
namespace Xtwo\SalesMailing\Model\Service;
use Aws\S3\S3Client;
class DocumentMover
{
    //const READ_PATH_PART = 'pdf'.DS.'__nav_pdf_import';
    const READ_PATH_PART = 'pdf'.'/'.'__nav_pdf_import';

    /**
     * @var \Magento\Framework\Event\ManagerInterface
     */
    protected $eventManager;

    /**
     * @var \Magento\Framework\Filesystem\Io\FileFactory
     */
    protected $ioFileFactory;
    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $storeManager;

    protected $salesMailingHelper;
    protected $scopeConfig;
    protected $dir;
    public function __construct(
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Xtwo\SalesMailing\Helper\Data $salesMailingHelper,
        \Magento\Framework\Filesystem\Io\File $ioFile,
        \Magento\Framework\Event\ManagerInterface $eventManager,
        \Xtwo\SalesMailing\Model\Service\FileResolver $fileResolver,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Framework\Filesystem\DirectoryList $dir,
		\Xtwo\SalesMailing\Model\Configuration $configurationModel,
		\Magento\Sales\Model\OrderFactory $salesOrderFactory,
		\Magento\Framework\DataObjectFactory $dataObjectFactory,
        
    ) {
        $this->storeManager = $storeManager;
        $this->salesMailingHelper=$salesMailingHelper;
        $this->ioFile = $ioFile;
        $this->eventManager = $eventManager;
        $this->_dir = $dir;
        $this->fileResolver = $fileResolver;
        $this->scopeConfig=$scopeConfig;
		$this->configurationModel = $configurationModel;
		$this->salesOrderFactory = $salesOrderFactory;
		$this->dataObjectFactory = $dataObjectFactory;
    }
    /**
     * Move documents
     *
     * @throws Exception
     */
    public function moveDocuments()
    {
        $fileList = $this->read();
       
        if (!empty($fileList)) {
           
            //Js_Log::log(sprintf('DocumentMover: found %s pdf docs', count($fileList)), $this, Zend_Log::INFO);
            $mappedFiles = $this->map($fileList);
            //Js_Log::log(sprintf('DocumentMover: %s pdf docs after mapping', count($mappedFiles)), $this, Zend_Log::INFO);
            $mappedFiles = $this->filter($mappedFiles);
            $this->moveOrDelete($mappedFiles);

        }
    }

    /**
     * Get file resolver service
     *
     * @return Justselling_InfoMailing_Model_Service_FileResolver
     */
    private function getFileResolver()
    {
        //return Mage::getSingleton('xtwo_salesmailing/service_fileResolver');
        return $this->fileResolver;
    }

    /**
     * @param $mappedFiles
     * @return array
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    private function filter($mappedFiles) {
       
        $results = []; $skipped = [];

        $configs = array();
        $configs['shipment'] = $this->salesMailingHelper
            ->getActiveConfigurationsOfSpecificType(\Xtwo\SalesMailing\Model\Configuration::TRIGGER_TYPE_EXT_SHIPMENT);
        $configs['invoice'] =  $this->salesMailingHelper //Mage::helper('xtwo_salesmailing')
            ->getActiveConfigurationsOfSpecificType(\Xtwo\SalesMailing\Model\Configuration::TRIGGER_TYPE_EXT_INVOICE);
        $configs['creditmemo'] = $this->salesMailingHelper
            ->getActiveConfigurationsOfSpecificType(\Xtwo\SalesMailing\Model\Configuration::TRIGGER_TYPE_EXT_CREDITMEMO);
        $configs['orderconfirmation'] = $this->salesMailingHelper
            ->getActiveConfigurationsOfSpecificType(\Xtwo\SalesMailing\Model\Configuration::TRIGGER_TYPE_EXT_ORDERCONFIRMATION);
        $configs['documents'] = $this->salesMailingHelper
            ->getActiveConfigurationsOfSpecificType(\Xtwo\SalesMailing\Model\Configuration::TRIGGER_TYPE_EXT_DOCUMENTS);


        $problems = []; $touched = []; $invalid = [];
        /** @var \Magento\Framework\DataObject $mappedFile */
		
        foreach ($mappedFiles as $mappedFile) {
			$tt= $mappedFile->getData('order');
			
			  $configurations = $this->salesMailingHelper->getActiveConfigurations();

            try {
                $key = $mappedFile->getData('file_name');
                
                if (!$key) {
                    //Js_Log::log(sprintf('DocumentMover: no data found for "file_name"'), $this, \Zend_Log::ALERT);
                    continue;
                }
                

                $configItems = $configs[$mappedFile->getType()];
                $oldPath = $mappedFile->getData('mod_date');
               
                $created = $oldPath ? filemtime($oldPath) : false;
                if (!$created && $oldPath) {
                    // Workaround for not getting a creation timestamp
                    $oldPathTmp = str_replace('.pdf', '_.pdf', $oldPath);
                    if ($cpResult = copy($oldPath, $oldPathTmp)) {
                        if ($cpResult = unlink($oldPath)) {
                            $cpResult = rename($oldPathTmp, $oldPath);
                        }
                    }
                    $touched[$key] = (int)$cpResult;
                }
                if (!$oldPath) {
                    // We don't have a valid PDF file name in this case ('old_path' not set and no order),
                    // but take it delete it
                    $invalid[$key] = $mappedFile;
                    $results[$key] = $mappedFile;
                }
               
                if ($created) {
                    $fileCreatedAt = new \Zend_Date($created, \Zend_Date::TIMESTAMP);
                    $fileCreatedAtString = $fileCreatedAt->toString(\Zend_Date::DATETIME_LONG);
                    $key .= ('/' . $fileCreatedAtString);

                    if (empty($configItems) && !empty($configs['documents'])) $configItems = $configs['documents'];
                    /** @var $config Justselling_InfoMailing_Model_Configuration */
                    $config = ($configItems && !empty($configItems)) ? reset($configItems) : false;

                    if ($config && isset($config['delay'])) {
                        //&& ($hrs = $config->getDelay())
                        if(isset($config['delay'])){
                            $hrs = intval( $config['delay']);
                        $limit = $fileCreatedAt->addHour($hrs);
                        $limitString = $limit->toString(\Zend_Date::DATETIME_LONG);
                        }
                        
                        $now = new \Zend_Date();
                        $nowString = $now->toString(\Zend_Date::DATETIME_LONG);
                        $isDelayReached = $now->isLater($limit);
                        if (!$isDelayReached) {
                            $skipped[$key] = $mappedFile;
                            continue;
                        }
                    }
					
					
							 $results[$key] = $mappedFile;
					

                }
               

            } catch (\Exception $e) {
                $problems[] = $e->getMessage();
                 $e->getMessage();
            }
        }

        if (!empty($problems)) {
            $firstFile = reset($problems);
            //Js_Log::log(sprintf('DocumentMover: %s total files, %s unexpected problems, first one=%s',
             //   count($mappedFiles), count($problems), $firstFile), $this, \Zend_Log::ALERT);
        }

        if (!empty($touched)) {
            $firstFile = reset(array_keys($touched));
            $failed = count(array_keys($touched, 0));
            //Js_Log::log(sprintf('DocumentMover: %s total files, touched %s docs as no creation date available (%s failures), first one=%s',
            //    count($mappedFiles), count($touched), $failed, $firstFile), $this, \Zend_Log::INFO);
        }

        if (!empty($invalid)) {
            //Js_Log::log(sprintf('DocumentMover: %s invalid files (as candidates for deletion)', count($invalid)),
            //    $this, \Zend_Log::INFO);
        }

        if (!empty($skipped)) {
            $firstFile = reset(array_keys($skipped));
            //Js_Log::log(sprintf('DocumentMover: %s total files, skipped %s docs as delay limit not reached, first one=%s',
            //    count($mappedFiles), count($skipped), $firstFile), $this, \Zend_Log::INFO);
        }

        if (!empty($results)) {

            //$firstFile = reset(array_keys($results));
            //Js_Log::log(sprintf('DocumentMover: %s total files, fetched %s docs as delay reached, first one=%s',
            //    count($mappedFiles), count($results), $firstFile), $this, \Zend_Log::INFO);
        } else {
            //Js_Log::log(sprintf('DocumentMover: 0 documents finally released'), $this, \Zend_Log::INFO);
        }
        
        return $results;
    }

    /**
     * Read files
     *
     * @return array
     * @throws Exception
     */
    private function read()
    {
        //$ioFile = $this->ioFileFactory->create();
        //$directoryPath = Mage::getConfig()->getOptions()->getVarDir() . DS . self::READ_PATH_PART . DS;
        //$directoryPath = $this->scopeConfig->getOptions()->getVarDir()  . self::READ_PATH_PART ;
        $directoryPath= $this->_dir->getPath('var').'/'. self::READ_PATH_PART.'/';
        $documentCdnAccessKey = $this->scopeConfig->getValue( 'aws_s3_connection/configuration/cdn_access_key', 
        \Magento\Store\Model\ScopeInterface::SCOPE_STORE); 
        $documentCdnsecretKey = $this->scopeConfig->getValue( 'aws_s3_connection/configuration/cdn_secret_key', 
        \Magento\Store\Model\ScopeInterface::SCOPE_STORE); 
        $documentCdnRegion = $this->scopeConfig->getValue( 'aws_s3_connection/configuration/cdn_region', 
        \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
        $documentCdnEndPoint = $this->scopeConfig->getValue( 'aws_s3_connection/configuration/cdn_end_point', 
        \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
        $bucketName = $this->scopeConfig->getValue( 'aws_s3_connection/configuration/cdn_bucket_name', 
        \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
        $version ='latest';
        $region = $documentCdnRegion;
        $s3Client = new S3Client([
            'version'     => $version,
            'region'      => $region, 
            //'endpoint'    => $customEndpoint,
            //'use_path_style_endpoint' => true, // Set to true if your custom endpoint uses path-style URLs
            'credentials' => [
                'key'    => $documentCdnAccessKey,
                'secret' => $documentCdnsecretKey,
            ],
             'scheme'  => 'http'
        ]);
        $fileList =[];
        try {
            $objects = $s3Client->listObjects([
                'Bucket' => $bucketName, 
                'Delimiter'=>'/', 
                'Prefix' => "_".self::READ_PATH_PART.'/',
                //'MaxKeys' => 2,
                ]);
               //$fileList =[];
               
               foreach ($objects['Contents'] as $content) {
                    if($content['Size']>0){
                        $fileList[] =[
                            'text' => $content['Key'],
                            'size' => $content['Size'],
                            'is_image' => false,
                            //'owner' => $content['Owner']['DisplayName'] ,
                            "filetype" => "pdf",
                            'mod_date' =>date('Y-m-d H:i:s',strtotime( $content['LastModified']->format(\DateTime::ISO8601)))
                        ];

                    }
               }

        }catch (\Exception $e){
            $e->getMessage();
        }
        
           
        //$ioFile->checkAndCreateFolder($directoryPath);
        #$this->ioFile->checkAndCreateFolder($directoryPath);
        //$ioFile->open(array('path' => $directoryPath));
        #$this->ioFile->open(array('path' => $directoryPath));
        //$fileList = $ioFile->ls(\Magento\Framework\Filesystem\Io\File::GREP_FILES);
        #$fileList = $this->ioFile->ls(\Magento\Framework\Filesystem\Io\File::GREP_FILES);
        //add directory path to file names, else we just have filename, but need full path to to perform file move
        if (!empty($fileList)) {
            array_walk(
                $fileList,
                function (&$v) use ($directoryPath) {
                    #$v['text'] = $directoryPath . $v['text'];
                    $v['text'] =  $v['text'];
                }
            );
        }

        return $fileList;
    }

    /**
     * Map files old-new path
     *
     * @param array $fileList
     *
     * @return array
     *
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    private function map($fileList)
    {
       
        $mapping = [];
        $noResolveInfo = [];
		$resolveInfo =[];
		$resultObject = $this->dataObjectFactory->create();
        $firstFile = null;
        foreach ($fileList as $file) {
            $fileName = $file['text'];
            if (is_null($firstFile)) $firstFile = $fileName;
            $fileName = pathinfo($fileName)['basename'];
			$incrementId = substr($fileName, 0, strpos($fileName, '_')); //str_replace(self::READ_SHIPMENT_PART_NAME, '', $fileName);
           
			
			if (($pos = strpos($fileName, \Xtwo\SalesMailing\Model\Service\FileResolver::READ_INVOICE_PART_NAME)) !== false) {
				 $incrementId = substr($fileName, 0, strpos($fileName, '_'));   // str_replace(self::READ_INVOICE_PART_NAME, '', $fileName);

                // position must be > 0 as it starts with order ID and must be a numeric order ID
                if ($pos > 0 && is_numeric($incrementId)) {
				$order = $this->salesOrderFactory->create()->loadByIncrementId($incrementId);
                  
                    if ($order && $order->getId()) {
				$resultObject->setData(array(
                            'increment_id' => $incrementId,
                            'type'         => 'invoice',
                            'file_name'    => $fileName,
                            //'path'         => reset($paths),
                            'order'        => $order));
					}
				}
            
			} elseif (($pos = strpos($fileName, \Xtwo\SalesMailing\Model\Service\FileResolver::READ_SHIPMENT_PART_NAME)) !== false) {
				$resultObject->setData(array(
                    'type'         => 'invoice',
                    'file_name'    => $fileName,
                    'order'        => null));
				$incrementId = substr($fileName, 0, strpos($fileName, '_')); //str_replace(self::READ_SHIPMENT_PART_NAME, '', $fileName);

                // position must be > 0 as it starts with order ID and must be a numeric order ID
                if ($pos > 0 && is_numeric($incrementId)) {
                    $order = $this->salesOrderFactory->create()->loadByIncrementId($incrementId);
                    
                    if ($order && $order->getId()) {
                       // $paths = $this->getShippingDocumentPath($order, $fileName);
                       
                        $resultObject->setData(array(
                                'increment_id' => $incrementId,
                                'type'         => 'shipment',
                                //'path'         => reset($paths),
                                'file_name'    => $fileName,
                                'order'        => $order));
                    }
                }
			} elseif (($pos = strpos($fileName, \Xtwo\SalesMailing\Model\Service\FileResolver::READ_ORDER_CONFIRMATION_PART_NAME)) !== false) {
				$resultObject->setData(array(
                    'type'         => 'orderconfirmation',
                    'file_name'    => $fileName,
                    'order'        => null));

                //if filename is shipment
                $incrementId = substr($fileName, 0, strpos($fileName, '_')); //str_replace(self::READ_SHIPMENT_PART_NAME, '', $fileName);

                // position must be > 0 as it starts with order ID and must be a numeric order ID
                if ($pos > 0 && is_numeric($incrementId)) {
                    $order = $this->salesOrderFactory->create()->loadByIncrementId($incrementId);
                    if ($order && $order->getId()) {
                        //$paths = $this->getOrderConfirmationDocumentPath($order, $fileName);
                        $resultObject->setData(array(
                            'increment_id' => $incrementId,
                            'type'         => 'orderconfirmation',
                            //'path'         => reset($paths),
                            'file_name'    => $fileName,
                            'order'        => $order));
                    }
                }
			} elseif (($pos = strpos($fileName, \Xtwo\SalesMailing\Model\Service\FileResolver::READ_CREDIT_MEMO_PART_NAME)) !== false) {
				$resultObject->setData(array(
                    'type'         => 'creditmemo',
                    'file_name'    => $fileName,
                    'order'        => null));

                //if filename is shipment
                $incrementId = substr($fileName, 0, strpos($fileName, '_')); //str_replace(self::READ_SHIPMENT_PART_NAME, '', $fileName);

                // position must be > 0 as it starts with order ID and must be a numeric order ID
                if ($pos > 0 && is_numeric($incrementId)) {
                    $order = $this->salesOrderFactory->create()->loadByIncrementId($incrementId);
                    if ($order && $order->getId()) {
                        //$paths = $this->getCreditMemoDocumentPath($order, $fileName);
                        $resultObject->setData(array(
                            'increment_id' => $incrementId,
                            'type'         => 'creditmemo',
                            //'path'         => reset($paths),
                            'file_name'    => $fileName,
                            'order'        => $order));
                    }
                }
			}
			
			$order = $this->salesOrderFactory->create()->loadByIncrementId($incrementId);
			 
			  $configurations = $this->salesMailingHelper->getActiveConfigurations();
                    /** @var \Xtwo\SalesMailing\Model\Configuration $configuration */
                    foreach ($configurations as $configuration) {

                        $configuration = $this->salesMailingHelper->getActiveConfiguration($configuration);
						
						 if ($this->configurationModel->matchesExternalTriggeredEvent($resultObject, $order)) {
							$resolveInfo = $this->getFileResolver()->resolve($fileName);
							//break;
						 }
					}

            if (!empty($resolveInfo) && $resolveInfo->getOrder()) {
                $resolveInfo->setOldPath($file['text']);
                $mapping[] = $resolveInfo;
            } elseif ($resolveInfo) {
                // is an invalid file or as we don't have order
                $resolveInfo->setData('src_path', $file['text']);
                $mapping[] = $resolveInfo;
            } else {
                $noResolveInfo[] = $file['text'];
            }
        }

        if (!empty($noResolveInfo)) {
            //Js_Log::log(sprintf('DocumentMover: %s resolves not successful, first=%s',
            //    count($noResolveInfo), $firstFile), $this, \Zend_Log::WARN);
        }
        
        return $mapping;
    }

    /**
     * Move files
     *
     * @param array $mappedFiles
     *
     * @throws \Exception
     */
    private function moveOrDelete($mappedFiles)
    {
        //$ioFile = new Varien_Io_File();
        $errors = []; $deleted = [];

        foreach ($mappedFiles as $mappedFile) {
			$mpOrder = $mappedFile->getOrder();
            
            // Check for deletion
            if (!$mappedFile->getOrder()) {
                //if (!$ioFile->rm($mappedFile->getSrcPath())) {
                    if (!$this->ioFile->rm($mappedFile->getSrcPath())) {
                    $errors[] = sprintf('Failed deletion of file "%s"', $mappedFile->getSrcPath());
                } else {
                    $deleted[] = $mappedFile->getSrcPath();
                }
                continue;
            }
            $fileName = $mappedFile->getData('file_name');
            //get file path and create directory if not exists
            $oldPath = $mappedFile->getOldPath();
            $newPath = $mappedFile->getPath();
            if ($newDirectoryPath = pathinfo($newPath, PATHINFO_DIRNAME)) {
                //$result = $ioFile->checkAndCreateFolder($newDirectoryPath);
                //$result = $this->ioFile->checkAndCreateFolder($newDirectoryPath);
                //if (!$result) {
                    //Js_Log::log(sprintf('Creation of folder "%s" failed. Please check!', $newDirectoryPath),
                    //    $this, \Zend_Log::ALERT);
               // }
            }
            $documentCdnAccessKey = $this->scopeConfig->getValue( 'aws_s3_connection/configuration/cdn_access_key', 
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE); 
            $documentCdnsecretKey = $this->scopeConfig->getValue( 'aws_s3_connection/configuration/cdn_secret_key', 
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE); 
            $documentCdnRegion = $this->scopeConfig->getValue( 'aws_s3_connection/configuration/cdn_region', 
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
            $documentCdnEndPoint = $this->scopeConfig->getValue( 'aws_s3_connection/configuration/cdn_end_point', 
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
            $bucketName = $this->scopeConfig->getValue( 'aws_s3_connection/configuration/cdn_bucket_name', 
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
            $version ='latest';
            $region = $documentCdnRegion;
            $s3Client = new S3Client([
                'version'     => $version,
                'region'      => $region, 
                //'endpoint'    => $customEndpoint,
                //'use_path_style_endpoint' => true, // Set to true if your custom endpoint uses path-style URLs
                'credentials' => [
                    'key'    => $documentCdnAccessKey,
                    'secret' => $documentCdnsecretKey,
                ],
            ]);
            $customEndpoint = $documentCdnEndPoint; // CDN custom endpoint URL
            $s3MediaFolder ='media';
            $s3PdfFolder ='_pdf';
            $version ='latest';
            try{

                #$folder = "copied-folder";
                $s3FileExist = $s3Client->doesObjectExist($bucketName, $bucketName."/"."_".self::READ_PATH_PART.'/'.$fileName);
                if($s3FileExist){
                    $s3Client->copyObject([
                        'Bucket' => $bucketName,
                        'CopySource' => $bucketName."/"."_".self::READ_PATH_PART.'/'.$fileName,
                        'Key' =>  $s3MediaFolder.'/'.$newPath,
                    ]);

                }
                
                /*$file = $s3Client->getObject([
                    'Bucket' => $bucketName,
                    'Key' => $s3MediaFolder.'/'.$newPath
                ]);
                $body = $file->get('Body');
                $date = $file->get('LastModified');

                if(empty($body)){
                    
                }*/

            }catch (\Exception $e){
                echo $e->getMessage();
            }
            //move file
            //$result = $ioFile->mv($oldPath, $newPath);
           // $result = $this->ioFile->mv($oldPath, $newPath);
            //Js_Log::log(sprintf('Moved document to target "%s" %s', $newPath, $result ? 'succeed.' : 'failed!'),
            //    $this,  $result ? \Zend_Log::INFO : Zend_Log::ALERT);

            //notify of file move
            $object = $mappedFile->getOrder();

            $event = '';
            if ($mappedFile->getType() === 'invoice') {
                $event = 'xtwo_invoice_pdf_received';
            } elseif ($mappedFile->getType() === 'shipment') {
                $event = 'xtwo_shipment_pdf_received';
            } elseif ($mappedFile->getType() === 'creditmemo') {
                $event = 'xtwo_creditmemo_pdf_received';
            } elseif ($mappedFile->getType() === 'orderconfirmation') {
                $event = 'xtwo_orderconfirmation_pdf_received';
            }
			//echo $event;
            if ($event) {
               // Js_Log::log(sprintf('fire: %s => %s', $event, $mappedFile->getPath()), $this, \Zend_Log::INFO);
               
                try{
                    $this->eventManager->dispatch($event, array('order' => $object, 'file' => $mappedFile));
                }catch(\Exception $e){
                    echo $e->getMessage();
                }
            }

        }

        if (!empty($errors)) {
            //Js_Log::log(sprintf("Following errors occured:\n%s", implode("\n", $errors)),
            //    $this, \Zend_Log::ALERT);
        }

        if (!empty($deleted)) {
            //Js_Log::log(sprintf("Successfully deleted %s docs:\n%s", count($deleted), implode("\n", $deleted)),
            //    $this, \Zend_Log::INFO);
        }

    }

}