<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_SalesMailing
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\SalesMailing\Model;

class QueueInfoMailResult 
{
    const STATUS_SUCCESS = 'SUCCESS';
    const STATUS_BLOCKED = 'BLOCKED';

    /** @var array  */
    private $statusInfo = [];
    /** @var string */
    private $status = self::STATUS_SUCCESS;

    public function setStatus($status)
    {
        $this->status = $status;
    }

    public function setStatusBlocked() {
        $this->status = self::STATUS_BLOCKED;
        $this->addStatusInfo('mail=BLOCKED');
    }

    /**
     * @return bool
     */
    public function isStatusSuccess() {
        return $this->status == self::STATUS_SUCCESS;
    }

    /**
     * @param $value
     */
    public function addStatusInfo($value)
    {
        
        $this->statusInfo[] = $value;
    }

    /**
     * @return string
     */
    public function getStatus() {
        return $this->status;
    }

    /**
     * @return array
     */
    public function getStatusInfo()
    {
        return $this->statusInfo;
    }

    /**
     * @return string
     */
    public function getStatusInfoAsString()
    {
        return implode(' ', $this->statusInfo);
    }


}